(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    272633,       6041]
NotebookOptionsPosition[    267606,       5892]
NotebookOutlinePosition[    267948,       5907]
CellTagsIndexPosition[    267905,       5904]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Header", "Section",
 CellChangeTimes->{{3.7138393590358686`*^9, 3.7138393720573626`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"S", ".", "A", ".", " ", "Fedorov"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7329454417467127`*^9, 3.7329454482982025`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7114630194690485`*^9, 3.7114630370457473`*^9}, {
   3.7136114493260565`*^9, 3.713611455306723*^9}, {3.713841371998087*^9, 
   3.713841384687706*^9}, 3.7329454550565205`*^9},
 ExpressionUUID -> "0f94cef6-bf39-4eaf-9ce3-af87df9898fa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Functions", "Section",
 CellChangeTimes->{{3.7138393749524937`*^9, 3.7138393823208733`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"QData", " ", 
   RowBox[{"format", ":", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Beam", " ", "number"}], ",", " ", 
      RowBox[{"f", " ", 
       RowBox[{"(", "MHz", ")"}]}], ",", " ", 
      RowBox[{"Q", " ", 
       RowBox[{"(", 
        RowBox[{"\[Times]", 
         RowBox[{"10", "^", "6"}]}], ")"}]}]}], "}"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.7138396164142027`*^9, 3.713839623549715*^9}, {
  3.7138399600541773`*^9, 3.7138399722758465`*^9}, {3.732945472648855*^9, 
  3.732945473949402*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"avergares", " ", "Q"}], "-", 
     RowBox[{
     "factors", " ", "for", " ", "the", " ", "entries", " ", "having", " ", 
      "the", " ", "same", " ", "beam", " ", "number"}]}], ",", " ", 
    RowBox[{"by", " ", "default", " ", 
     RowBox[{"(", 
      RowBox[{
      "if", " ", "\[CapitalDelta]\[Nu]Same", " ", "is", " ", "unspecified"}], 
      ")"}], " ", "assumes", " ", "1", " ", "mode", " ", "per", " ", 
     "beam"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"AverageQFactors", "[", 
     RowBox[{"QData_", ",", 
      RowBox[{"\[CapitalDelta]\[Nu]Same_:", "Null"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"NBeamList", ",", "QDataSel", ",", "sameF", ",", "ret"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NBeamList", "=", 
        RowBox[{"DeleteDuplicates", "[", 
         RowBox[{"QData", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sameF", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"\[CapitalDelta]\[Nu]Same", "===", "Null"}], ",", 
          RowBox[{"1", "&"}], ",", 
          RowBox[{
           RowBox[{"Round", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             "\[CapitalDelta]\[Nu]Same"}], "]"}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ret", "=", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"QDataSel", "=", 
            RowBox[{"SplitBy", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"QData", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "NBeam"}], 
                  ")"}], "&"}]}], "]"}], ",", "sameF"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             FractionBox[
              RowBox[{"Total", "[", "QDataSubSel", "]"}], 
              RowBox[{"Length", "[", "QDataSubSel", "]"}]], ",", 
             RowBox[{"{", 
              RowBox[{"QDataSubSel", ",", "QDataSel"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"NBeam", ",", "NBeamList"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Sort", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"ret", ",", "1"}], "]"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ">", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7138394118994555`*^9, 3.7138394622035103`*^9}, {
   3.713839572521016*^9, 3.713839657430279*^9}, {3.7138398488284435`*^9, 
   3.7138398544787216`*^9}, {3.7149880360399723`*^9, 3.714988045124079*^9}, {
   3.714988349425999*^9, 3.714988363858982*^9}, {3.714988396075266*^9, 
   3.7149884289101906`*^9}, {3.714988475231639*^9, 3.7149884760107965`*^9}, {
   3.7149885800447416`*^9, 3.7149886219571986`*^9}, {3.7149887237142353`*^9, 
   3.7149887889233894`*^9}, {3.7149889432471857`*^9, 3.71498899071564*^9}, {
   3.7149891837622538`*^9, 3.7149891860795827`*^9}, 3.714989222018216*^9, {
   3.714989375125098*^9, 3.7149893898453484`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"From", " ", "the", " ", "measurements", " ", "table"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "select", " ", "only", " ", "those", " ", "entries", " ", "that", " ", 
       "have", " ", "information", " ", "on", " ", "both", " ", "frequency", 
       " ", "and", " ", "quality", " ", 
       RowBox[{"factor", ".", " ", "Optionally"}], " ", "also", " ", 
       "selects", " ", "only", " ", "the", " ", "entries", " ", "with", " ", 
       "Q"}], ">", "QThreshold"}], ";", "\[IndentingNewLine]", 
     RowBox[{"QDataTable", " ", 
      RowBox[{"format", ":", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Beam", " ", "number"}], ",", " ", 
         RowBox[{"f", " ", 
          RowBox[{"(", "MHz", ")"}]}], ",", " ", 
         RowBox[{"Q", " ", 
          RowBox[{"(", 
           RowBox[{"\[Times]", 
            RowBox[{"10", "^", "6"}]}], ")"}]}], ",", " ", "Comment"}], 
        "}"}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SelectFullQEntries", "[", 
     RowBox[{"QDataTable_", ",", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", 
        RowBox[{"QThreshold", "\[Rule]", 
         RowBox[{"-", "1"}]}], "}"}], "]"}]}], "]"}], ":=", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"QDataTable", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NumberQ", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"NumberQ", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"NumberQ", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ">", 
           RowBox[{"OptionValue", "[", "QThreshold", "]"}]}], ")"}]}], ")"}], 
       "&"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.713840655370558*^9, 3.713840909281171*^9}, {
  3.7138420635294714`*^9, 3.7138421078473034`*^9}, {3.7138421522599964`*^9, 
  3.713842154707021*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Data processing", "Section",
 CellChangeTimes->{{3.7138393848495145`*^9, 3.7138393934605274`*^9}}],

Cell[CellGroupData[{

Cell["Data loading", "Subsection",
 CellChangeTimes->{{3.713840009211445*^9, 3.7138400235676394`*^9}, {
  3.71384133834262*^9, 3.713841338796728*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Q", " ", "factros", " ", "file", " ", 
   RowBox[{"format", ":", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Beam", " ", "number"}], ",", " ", 
      RowBox[{"f", " ", 
       RowBox[{"(", "MHz", ")"}]}], ",", " ", 
      RowBox[{"Q", " ", 
       RowBox[{"(", 
        RowBox[{"\[Times]", 
         RowBox[{"10", "^", "6"}]}], ")"}]}], ",", " ", "Comment"}], 
     "}"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.713839987796736*^9, 3.7138399964262624`*^9}, {
  3.7138407406729555`*^9, 3.713840741219912*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"base", " ", "directory"}], ",", 
    RowBox[{
    "containing", " ", "the", " ", "folders", " ", "with", " ", "raw", " ", 
     "data"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"baseDirectory", "=", "\"\<.\\\\\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "list", " ", "of", " ", "the", " ", "raw", " ", "data", " ", "folders"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirList", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "\"\<2017-09-15 UQ31_stress_14cell_4mm\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-19 UQ31_4mm_18unitcell\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-20 UQ31_4mm_20unitcell\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-20 UQ31_stress_28cell_4mm\>\"", 
       ",", "\[IndentingNewLine]", 
       "\"\<2017-09-19 UQ31_stress_30cell_4mm\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-05 UQ31_stress_34cell_4mm\>\"", 
       ",", "\[IndentingNewLine]", 
       "\"\<2017-09-08 UQ31_stress_36cell_4mm\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-10-10 UQ35_stress_59cell_4mm\>\""}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QFactorsFileName", "=", "\"\<Q factors.txt\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirListFull", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"baseDirectory", ",", "subDirName"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"subDirName", ",", "rawDataDirList"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.713840073972213*^9, 3.713840316990381*^9}, {
   3.7138403680776234`*^9, 3.7138403867983294`*^9}, {3.713840571187002*^9, 
   3.7138405849294653`*^9}, 3.7138572578721075`*^9, {3.7149858231068993`*^9, 
   3.7149858468745685`*^9}, {3.714986033801119*^9, 3.714986057800376*^9}, {
   3.7149861053968844`*^9, 3.7149861348968086`*^9}, {3.7149870583843327`*^9, 
   3.7149870615933065`*^9}, {3.717427207614753*^9, 3.717427210316352*^9}, {
   3.7329458268056655`*^9, 3.732945827505659*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"QDataTables", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"dirName", ",", "QFactorsFileName"}], "}"}], "]"}], ",", 
       "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\<\\t\>\""}], ",", 
       RowBox[{"\"\<RepeatedSeparators\>\"", "\[Rule]", "False"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"dirName", ",", "rawDataDirListFull"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.71146319227089*^9, 3.7114632094854555`*^9}, {
  3.7114632869230704`*^9, 3.7114633010375557`*^9}, {3.7120328893790812`*^9, 
  3.712032906959397*^9}, {3.713840471041848*^9, 3.7138405335592337`*^9}, {
  3.7138410119614544`*^9, 3.713841040556593*^9}, {3.713841567353223*^9, 
  3.713841601935092*^9}, {3.713842001890781*^9, 3.713842014144478*^9}, {
  3.7138421209729443`*^9, 3.713842134067696*^9}},
 ExpressionUUID -> "6e62ad71-6017-40eb-9159-26078f1fd163"]
}, Closed]],

Cell[CellGroupData[{

Cell["Raw data overview", "Subsection",
 CellChangeTimes->{{3.7138421833400097`*^9, 3.713842205334895*^9}, {
  3.713842407108616*^9, 3.71384240874142*^9}, {3.7138431830120506`*^9, 
  3.713843184449935*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"\"\<Measurement folder name: \>\"", "~~", 
         RowBox[{"rawDataDirList", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", "Bold", ",", "14"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"QDataTables", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "//", "TableForm"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<\\n\>\"", "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "QDataTables", "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.713841612449684*^9, 3.713841619187951*^9}, {
  3.713842191643379*^9, 3.7138421973147383`*^9}, {3.7138422284993057`*^9, 
  3.7138423868705378`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-15 UQ31_stress_14cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam Number\"\>", "\<\"Freq\"\>", "\<\"Q\"\>"},
    {"5", "1.285908875`", "4.059533366`"},
    {"6", "1.275554125`", "18.11170926`"},
    {"7", "1.267679125`", "32.21658691`"},
    {"8", "1.25702775`", "101.659693`"},
    {"8", "1.25720775`", "79.61098161`"},
    {"8", "1.257292438`", "80.49530764`"},
    {"10", "1.2477265`", "100.5059535`"},
    {"10", "1.19228425`", "24.97258628`"},
    {"11", "1.245099`", "89.95447146`"},
    {"0", "1.204870625`", "45.8603842`"},
    {"66", "1.25881725`", "229.8252686`"},
    {"65", "1.276001125`", "13.57952192`"},
    {"64", "1.280660125`", "69.58187893`"},
    {"61", "1.311628625`", "350.833622`"},
    {"59", "1.324718125`", "158.6248802`"},
    {"58", "1.352406`", "300.5819181`"},
    {"57", "1.298095`", "112.2889617`"},
    {"53", "1.38674375`", "282.8322949`"},
    {"50", "1.408751`", "216.9133297`"},
    {"45", "1.43240975`", "148.3863602`"},
    {"44", "1.4488985`", "117.9017702`"},
    {"43", "1.46331675`", "116.4498576`"},
    {"39", "1.4937245`", "293.928391`"},
    {"38", "1.4871345`", "180.0768645`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_4mm_18unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam Number\"\>", "\<\"Freq\"\>", "\<\"Q\"\>"},
    {"74", "1.322279875`", "0.904612514`"},
    {"74", "1.2430175`", "1.027511104`"},
    {"74", "1.615018125`", "11.75274205`"},
    {"73", "1.42762625`", "8.142504092`"},
    {"70", "1.6453775`", "52.78181817`"},
    {"70", "1.258452625`", "5.91614315`"},
    {"69", "1.3645725`", "8.025519366`"},
    {"69", "1.662068`", "20.06881546`"},
    {"68", "1.262829`", "3.924107246`"},
    {"75", "1.6311665`", "16.86993474`"},
    {"71", "1.65087325`", "18.31416897`"},
    {"69", "1.955058125`", "6.400160052`"},
    {"69", "1.66247475`", "18.20400848`"},
    {"68", "1.693850375`", "134.949893`"},
    {"64", "1.720007`", "160.1942938`"},
    {"63", "1.96045275`", "6.045876021`"},
    {"61", "1.765293`", "166.7919863`"},
    {"58", "1.79466675`", "21.52005642`"},
    {"57", "1.97174125`", "4.693834929`"},
    {"4", "1.6430535`", "49.56353861`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_4mm_20unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194263935`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam Number\"\>", "\<\"Freq[MHz]\"\>", "\<\"Q, 10^6\"\>"},
    {"1", "1.729831375`", "1.902857222`"},
    {"2", "1.734216`", "1.230670684`"},
    {"2", "1.73425975`", "1.448717295`"},
    {"3", "1.739776875`", "3.252826172`"},
    {"4", "1.745052125`", "1.64418912`"},
    {"4", "1.74513775`", "0.922386541`"},
    {"5", "1.7411475`", "2.780984736`"},
    {"6", "1.728`", "\<\"\"\>"},
    {"7", "1.74947625`", "0.985772066`"},
    {"8", "1.755`", "\<\"\"\>"},
    {"9", "1.746`", "\<\"\"\>"},
    {"10", "1.766`", "\<\"\"\>"},
    {"11", "\<\"\"\>", "\<\"\"\>"},
    {"12", "\<\"\"\>", "\<\"\"\>"},
    {"13", "\<\"\"\>", "\<\"\"\>"},
    {"14", "\<\"\"\>", "\<\"\"\>"},
    {"15", "1.74234375`", "4.673703172`"},
    {"15", "1.742428125`", "3.753468592`"},
    {"42", "1.773`", "\<\"\"\>"},
    {"58", "1.93299625`", "158.6905461`"},
    {"59", "1.922092`", "187.1345173`"},
    {"59", "1.922117`", "224.6315605`"},
    {"61", "1.901173625`", "220.7277657`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319442022*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319442022*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_stress_28cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319442022*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"76", "2.576`", "\<\"\"\>", "\<\"can't drive (not a high-Q mode?)\"\>"},
    {"75", "2.62417618`", "153.116`", "\<\"\"\>"},
    {"75", "2.6257046`", "123.017`", "\<\"\"\>"},
    {"75", "2.62556006`", "124.871`", "\<\"\"\>"},
    {"75", "2.62542703`", "138.274`", "\<\"\"\>"},
    {"75", "2.62536216`", "140.582`", "\<\"\"\>"},
    {"74", "2.601`", "\<\"\"\>", "\<\"low Q, no ringdown\"\>"},
    {"73", "2.62367067`", "144.528`", "\<\"\"\>"},
    {"73", "2.62365065`", "125.959`", "\<\"\"\>"},
    {"73", "2.62354555`", "122.657`", "\<\"\"\>"},
    {"72", "2.64206817`", "37.685`", "\<\"\"\>"},
    {"72", "2.64205616`", "42.955`", "\<\"\"\>"},
    {"71", "2.65936036`", "162.09`", "\<\"\"\>"},
    {"71", "2.65939039`", "171.52`", "\<\"\"\>"},
    {"70", "2.6662012`", "110.894`", "\<\"\"\>"},
    {"70", "2.6662042`", "108.737`", "\<\"\"\>"},
    {"69", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"68", "2.72903303`", "225.802`", "\<\"\"\>"},
    {"68", "2.72917718`", "274.771`", "\<\"\"\>"},
    {"68", "2.72917117`", "231.135`", "\<\"\"\>"},
    {"68", "2.72915516`", "239.328`", "\<\"\"\>"},
    {"67", "2.71442543`", "252.488`", "\<\"\"\>"},
    {"67", "2.71441041`", "194.522`", "\<\"\"\>"},
    {"67", "2.7143003`", "227.891`", "\<\"\"\>"},
    {"66", "2.73866066`", "185.487`", "\<\"\"\>"},
    {"66", "2.7387007`", "207.185`", "\<\"\"\>"},
    {"66", "2.73863564`", "199.605`", "\<\"\"\>"},
    {"65", "2.74457558`", "76.78`", "\<\"\"\>"},
    {"65", "2.74473574`", "67.229`", "\<\"\"\>"},
    {"64", "2.75804905`", "189.527`", "\<\"\"\>"},
    {"64", "2.75790891`", "196.165`", "\<\"\"\>"},
    {"63", "2.75795296`", "76.755`", "\<\"\"\>"},
    {"63", "2.75812913`", "87.612`", "\<\"\"\>"},
    {"63", "2.75817318`", "80.298`", "\<\"\"\>"},
    {"62", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"61", "2.8114955`", "204.811`", "\<\"\"\>"},
    {"61", "2.81155556`", "213.645`", "\<\"\"\>"},
    {"60", "2.79506006`", "32.087`", "\<\"\"\>"},
    {"60", "2.79508008`", "35.206`", "\<\"\"\>"},
    {"59", "2.81245245`", 
     "207.098`", "\<\"non-linear decay at high amplitudes\"\>"},
    {"59", "2.81261662`", "159.535`", "\<\"\"\>"},
    {"59", "2.81264064`", "155.08`", "\<\"\"\>"},
    {"58", "2.83470371`", "16.289`", "\<\"\"\>"},
    {"57", "2.837`", "\<\"\"\>", "\<\"low Q, no ringdown\"\>"},
    {"56", "2.84530631`", "54.305`", "\<\"\"\>"},
    {"56", "2.84537838`", "60.882`", "\<\"\"\>"},
    {"55", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"54", "2.89208008`", "102.545`", "\<\"\"\>"},
    {"54", "2.89208408`", "102.211`", "\<\"\"\>"},
    {"53", "2.87248048`", "150.645`", "\<\"\"\>"},
    {"53", "2.87257257`", "157.176`", "\<\"\"\>"},
    {"52", "2.88528128`", "160.517`", "\<\"\"\>"},
    {"52", "2.88544845`", "153.721`", "\<\"\"\>"},
    {"51", "2.917`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"50", "2.90354555`", "113.773`", "\<\"\"\>"},
    {"49", "2.91673073`", "122.563`", "\<\"\"\>"},
    {"49", "2.91705606`", "138.005`", "\<\"\"\>"},
    {"48", "2.92575275`", "134.648`", "\<\"\"\>"},
    {"48", "2.92587288`", "131.559`", "\<\"\"\>"},
    {"47", "2.95498208`", "112.195`", "\<\"\"\>"},
    {"47", "2.95513804`", "103.617`", "\<\"\"\>"},
    {"46", "2.93945976`", "105.55`", "\<\"\"\>"},
    {"46", "2.93963664`", "129.724`", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319442022*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319442022*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_stress_30cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194576464`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"Q bad by eye\"\>"},
    {"2", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"3", "2.70678078`", "3.288`", "\<\"\"\>"},
    {"4", "2.70179279`", "156.842`", "\<\"\"\>"},
    {"4", "2.70233333`", "151.79`", "\<\"\"\>"},
    {"5", "2.69736637`", "69.008`", "\<\"\"\>"},
    {"5", "2.69778679`", "97.65`", "\<\"\"\>"},
    {"5", "2.69788288`", "121.852`", "\<\"\"\>"},
    {"5", "2.69793694`", "95.896`", "\<\"\"\>"},
    {"6", "2.6820971`", "140.962`", "\<\"\"\>"},
    {"6", "2.6823934`", "146.896`", "\<\"\"\>"},
    {"7", "2.66282082`", "131.206`", "\<\"\"\>"},
    {"7", "2.66316116`", "142.955`", "\<\"\"\>"},
    {"8", "2.64802703`", "78.855`", "\<\"\"\>"},
    {"9", "2.64387287`", "105.736`", "\<\"\"\>"},
    {"9", "2.64431532`", "150.065`", "\<\"\"\>"},
    {"9", "2.64440641`", "171.349`", "\<\"\"\>"},
    {"9", "2.64446246`", "141.218`", "\<\"\"\>"},
    {"9", "2.64478479`", "136.263`", "\<\"\"\>"},
    {"10", "2.62908709`", "35.705`", "\<\"\"\>"},
    {"11", "2.62396096`", "88.669`", "\<\"\"\>"},
    {"11", "2.62402403`", "89.841`", "\<\"\"\>"},
    {"12", "2.61412813`", "26.665`", "\<\"\"\>"},
    {"13", "2.59`", "\<\"\"\>", "\<\"Q<10^7\"\>"},
    {"14", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"15", "2.57518118`", "10.627`", "\<\"\"\>"},
    {"16", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"17", "2.56037037`", "6.676`", "\<\"\"\>"},
    {"76", "2.78798719`", "51.861`", "\<\"\"\>"},
    {"75", "2.83377278`", "60.776`", "\<\"\"\>"},
    {"74", "2.81427628`", "58.893`", "\<\"\"\>"},
    {"73", "2.84071572`", "81.78`", "\<\"\"\>"},
    {"72", "2.86297147`", "20.593`", "\<\"\"\>"},
    {"71", "2.87934835`", "170.869`", "\<\"\"\>"},
    {"71", "2.87949049`", "163.585`", "\<\"\"\>"},
    {"70", "2.88515916`", "144.686`", "\<\"\"\>"},
    {"70", "2.8853934`", "141.628`", "\<\"\"\>"},
    {"69", "\<\"\"\>", "\<\"\"\>", "\<\"self-oscillating\"\>"},
    {"68", "2.94510511`", "126.374`", "\<\"\"\>"},
    {"68", "2.94547348`", "129.343`", "\<\"\"\>"},
    {"67", "2.92432032`", "192.804`", "\<\"\"\>"},
    {"67", "2.92471271`", "274.333`", "\<\"\"\>"},
    {"67", "2.92477277`", "267.012`", "\<\"\"\>"},
    {"66", "2.9405005`", "179.268`", "\<\"\"\>"},
    {"66", "2.94071071`", "196.394`", "\<\"\"\>"},
    {"65", "2.95878879`", "105.662`", "\<\"\"\>"},
    {"65", "2.959001`", "104.933`", "\<\"\"\>"},
    {"64", "2.96828128`", 
     "141.249`", "\<\"non-esponential decay at high amplitude\"\>"},
    {"64", "2.96851151`", "175.611`", "\<\"\"\>"},
    {"64", "2.96863263`", "184.617`", "\<\"\"\>"},
    {"63", "\<\"\"\>", "\<\"\"\>", "\<\"No beam?\"\>"},
    {"62", "2.98327027`", "154.327`", "\<\"\"\>"},
    {"62", "2.98346246`", "170.436`", "\<\"\"\>"},
    {"61", "\<\"\"\>", "\<\"\"\>", "\<\"No signal\"\>"},
    {"60", "\<\"\"\>", "\<\"\"\>", "\<\"self-excited\"\>"},
    {"59", "3.02271351`", "140.037`", "\<\"\"\>"},
    {"58", "3.06211712`", "56.309`", "\<\"\"\>"},
    {"57", "3.053`", "\<\"\"\>", "\<\"low Q\"\>"},
    {"54", "3.09784444`", "146.545`", "\<\"\"\>"},
    {"54", "3.09765315`", "151.855`", "\<\"\"\>"},
    {"53", "3.08267568`", "88.657`", "\<\"\"\>"},
    {"53", "3.08297177`", "120.474`", "\<\"\"\>"},
    {"52", "\<\"\"\>", "\<\"\"\>", "\<\"No signal\"\>"},
    {"51", "\<\"\"\>", "\<\"\"\>", "\<\"Self-excited\"\>"},
    {"50", "3.11907007`", "159.305`", "\<\"\"\>"},
    {"50", "3.11905806`", "153.276`", "\<\"\"\>"},
    {"49", "3.12567718`", "82.641`", "\<\"\"\>"},
    {"48", "3.13238439`", "88.941`", "\<\"\"\>"},
    {"48", "3.1326006`", "87.15`", "\<\"\"\>"},
    {"\<\"45-47\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"No signal\"\>"},
    {"44", "3.19`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"43", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"41", "3.19167528`", "46.963`", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194576464`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194576464`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-05 UQ31_stress_34cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194576464`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"1", "3.07648224`", "122.399`", "\<\"beatings in the signal\"\>"},
    {"1", "3.07668435`", "127.448`", "\<\"\"\>"},
    {"2", "3.0967844`", "\<\"\"\>", "\<\"Q<10^7\"\>"},
    {"3", "3.05852477`", 
     "102.559`", "\<\"self-excited, not a reliable number\"\>"},
    {"3", "3.05847224`", "118.38`", "\<\"\"\>"},
    {"4", "3.05015508`", "19.388`", "\<\"\"\>"},
    {"5", "3.04557129`", "108.84`", "\<\"\"\>"},
    {"5", "3.04615608`", "166.938`", "\<\"\"\>"},
    {"5", "3.04633017`", "96.192`", "\<\"\"\>"},
    {"6", "3.03304253`", "140.518`", "\<\"beating in the ringdown\"\>"},
    {"6", "3.0333887`", "162.838`", "\<\"\"\>"},
    {"7", "3.00349676`", "63.706`", "\<\"beating in the ringdown\"\>"},
    {"7", "3.00401901`", "69.328`", "\<\"\"\>"},
    {"8", "2.98173087`", "79.502`", "\<\"\"\>"},
    {"8", "2.98248324`", "93.139`", "\<\"\"\>"},
    {"9", "3.00073938`", "95.235`", "\<\"\"\>"},
    {"9", "3.00121962`", "132.489`", "\<\"\"\>"},
    {"10", "2.964`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"11", "2.95417409`", "85.651`", "\<\"\"\>"},
    {"11", "2.95453827`", "59.793`", "\<\"\"\>"},
    {"12", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"13", "2.94763332`", "47.641`", "\<\"strong beatings\"\>"},
    {"13", "2.94799525`", "64.999`", "\<\"\"\>"},
    {"14", "2.91750425`", "1.637`", "\<\"\"\>"},
    {"35", "3.666`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"36", "3.655`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"37", "3.654`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"38", "3.638`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"42", "2.92`", "\<\"\"\>", "\<\"not a localized mode, broad by eye\"\>"},
    {"63", "3.3812811`", "198.286`", "\<\"\"\>"},
    {"68", "3.36413334`", "219.057`", "\<\"\"\>"},
    {"68", "3.3644063`", "97.712`", "\<\"\"\>"},
    {"68", "3.36408931`", "294.66`", "\<\"looks reliable\"\>"},
    {"68", "3.36477251`", "266.777`", "\<\"looks reliable\"\>"},
    {"68", "3.36477196`", "204.598`", "\<\"looks reliable\"\>"},
    {"69", "3.31450028`", "152.935`", "\<\"\"\>"},
    {"69", "3.31475853`", "277.982`", "\<\"\"\>"},
    {"70", "3.29481251`", "202.893`", "\<\"\"\>"},
    {"70", "3.29459155`", "147.387`", "\<\"\"\>"},
    {"70", "3.29467564`", "133.23`", "\<\"\"\>"},
    {"71", "3.30655253`", "117.847`", "\<\"\"\>"},
    {"72", "3.29703317`", "86.229`", "\<\"?\"\>"},
    {"72", "3.2972016`", "214.92`", "\<\"more reliable\"\>"},
    {"72", "3.29706153`", "277.181`", "\<\"\"\>"},
    {"73", "3.26456778`", "184.194`", "\<\"\"\>"},
    {"73", "3.264599`", "182.595`", "\<\"\"\>"},
    {"73", "3.264599`", "147.563`", "\<\"\"\>"},
    {"74", "3.25686338`", 
     "333.885`", "\<\"Qf=10^15? almost too good to be true\"\>"},
    {"74", "3.25724637`", "336.901`", "\<\"\"\>"},
    {"74", "3.25767409`", "385.304`", "\<\"\"\>"},
    {"74", "3.25775593`", "256.311`", "\<\"\"\>"},
    {"74", "3.25813377`", "373.864`", "\<\"\"\>"},
    {"74", "3.25822201`", "140.723`", "\<\"\"\>"},
    {"74", "3.2581951`", "218.231`", "\<\"\"\>"},
    {"74", "3.2582052`", "461.257`", "\<\"\"\>"},
    {"74", "3.2582052`", "277.284`", "\<\"\"\>"},
    {"74", "3.25550117`", 
     "372.098`", "\<\"here and below for this beam measure at twice lower \
power (1 mW)\"\>"},
    {"74", "3.25460506`", "377.135`", "\<\"\"\>"},
    {"74", "3.25452702`", "246.34`", "\<\"\"\>"},
    {"74", "3.25442641`", "375.59`", "\<\"\"\>"},
    {"75", "3.28255828`", "152.806`", "\<\"\"\>"},
    {"75", "3.28265183`", "122.141`", "\<\"\"\>"},
    {"76", "3.22837669`", "254.479`", "\<\"\"\>"},
    {"76", "3.22895518`", "245.302`", "\<\"\"\>"},
    {"62", "3.39784094`", "128.161`", "\<\"poor s/n\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194576464`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319473282*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-08 UQ31_stress_36cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319473282*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"1", "3.23097324`", "101.574`", "\<\"\"\>"},
    {"1", "3.23124218`", "103.857`", "\<\"\"\>"},
    {"2", "3.24195824`", "3.757`", "\<\"\"\>"},
    {"3", "3.20493543`", "114.281`", "\<\"\"\>"},
    {"3", "3.20511713`", "117.92`", "\<\"\"\>"},
    {"4", "3.19310232`", "109.304`", "\<\"\"\>"},
    {"5", "3.19416608`", "106.158`", "\<\"\"\>"},
    {"5", "3.19430886`", "87.995`", "\<\"\"\>"},
    {"6", "3.17984142`", "51.124`", "\<\"\"\>"},
    {"6", "3.18007204`", "32.126`", "\<\"\"\>"},
    {"7", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"8", "3.12518209`", "0.681`", "\<\"\"\>"},
    {"11", "3.0930036`", "23.769`", "\<\"\"\>"},
    {"41", "3.79635128`", "15.127`", "\<\"\"\>"},
    {"42", "3.79228005`", "12.67`", "\<\"\"\>"},
    {"45", "3.7697328`", "68.563`", "\<\"\"\>"},
    {"45", "3.76993048`", "31.465`", "\<\"\"\>"},
    {"47", "3.76464634`", "36.299`", "\<\"\"\>"},
    {"60", "3.6022072`", "139.027`", "\<\"\"\>"},
    {"60", "3.6022072`", "127.611`", "\<\"\"\>"},
    {"60", "3.6022072`", "130.215`", "\<\"\"\>"},
    {"61", "3.6260928`", "59.203`", "\<\"\"\>"},
    {"61", "3.62573524`", "71.788`", "\<\"\"\>"},
    {"72", "3.46792936`", "84.407`", "\<\"\"\>"},
    {"73", "3.4318809`", "86.962`", "\<\"\"\>"},
    {"74", "\<\"\"\>", "\<\"\"\>", "\<\"self-excited\"\>"},
    {"75", "3.4614937`", "244.017`", "\<\"easy to drive\"\>"},
    {"75", "3.46191452`", "143.165`", "\<\"\"\>"},
    {"75", "3.46191452`", "163.076`", "\<\"\"\>"},
    {"76", "3.40292742`", "151.861`", "\<\"\"\>"},
    {"76", "3.40309059`", "204.246`", "\<\"\"\>"},
    {"76", "3.40315416`", "183.08`", "\<\"\"\>"},
    {"71", "\<\"\"\>", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"70", "3.46510592`", "124.92`", "\<\"\"\>"},
    {"70", "3.46512973`", "233.763`", "\<\"\"\>"},
    {"70", "3.46521533`", "169.171`", "\<\"\"\>"},
    {"70", "3.46552374`", "343.413`", "\<\"probably not very reliable\"\>"},
    {"70", "3.46586918`", "149.411`", "\<\"\"\>"},
    {"70", "3.46608941`", "136.098`", "\<\"\"\>"},
    {"69", "3.496`", "\<\"\"\>", "\<\"Q not good by eye\"\>"},
    {"68", "3.54816817`", "8.532`", "\<\"\"\>"},
    {"67", "3.5050988`", "20.375`", "\<\"\"\>"},
    {"66", "3.5160946`", "129.203`", "\<\"\"\>"},
    {"66", "3.5160946`", "87.335`", "\<\"\"\>"},
    {"66", "3.51608359`", "109.303`", "\<\"\"\>"},
    {"65", "3.561`", "\<\"\"\>", "\<\"not good by eye\"\>"},
    {"64", "3.556`", "\<\"\"\>", "\<\"not measured, but below 10^7\"\>"},
    {"60", "\<\"\"\>", "\<\"\"\>", "\<\"self-excited, not measured\"\>"},
    {"59", "3.61560079`", "200.242`", "\<\"\"\>"},
    {"59", "3.61564344`", "132.433`", "\<\"good S/N\"\>"},
    {"59", "3.61570731`", "269.321`", "\<\"also good S/N\"\>"},
    {"59", "3.61569329`", "170.329`", "\<\"\"\>"},
    {"58", "3.667`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"57", "\<\"\"\>", "\<\"\"\>", "\<\"self-driven oscillations, not \
measured\"\>"},
    {"56", "3.647`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"55", "3.649`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"54", "3.70240651`", "118", "\<\"\"\>"},
    {"54", "3.70263894`", "110.347`", "\<\"\"\>"},
    {"\<\"51-53\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"50", "3.712`", "\<\"\"\>", "\<\"can't drive\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319473282*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.732948319473282*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-10-10 UQ35_stress_59cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194888973`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"50", "5.42609105`", "95.845`", "\<\"\"\>"},
    {"50", "5.4268047`", "112.552`", "\<\"\"\>"},
    {"50", "5.42635618`", "88.871`", "\<\"\"\>"},
    {"50", "5.42637319`", "95.179`", "\<\"\"\>"},
    {"48", "5.36033267`", "5.11`", "\<\"\"\>"},
    {"48", "5.36065734`", "3.424`", "\<\"\"\>"},
    {"45", "5.3605953`", "85.286`", "\<\"\"\>"},
    {"45", "5.36071346`", "93.454`", "\<\"\"\>"},
    {"44", "5.43661594`", "69.742`", "\<\"nice ringdowns on this beam\"\>"},
    {"44", "5.43660712`", "73.843`", "\<\"\"\>"},
    {"44", "5.43660859`", "67.156`", "\<\"\"\>"},
    {"42", 
     "5.4363262`", "\<\"\"\>", "\<\"(Q=182.838?)something strange, not real\"\
\>"},
    {"42", "5.43620707`", "104.255`", "\<\"nice ringdowns on this beam\"\>"},
    {"42", "5.43623796`", "106.503`", "\<\"\"\>"},
    {"42", "5.43627767`", "104.948`", "\<\"\"\>"},
    {"39", "5.59721808`", "1.824`", "\<\"\"\>"},
    {"38", "5.49748225`", "51.738`", "\<\"\"\>"},
    {"38", "5.49755357`", "56.1`", "\<\"\"\>"},
    {"34", "5.51871762`", "67.622`", "\<\"\"\>"},
    {"34", "5.51871887`", "66.244`", "\<\"\"\>"},
    {"34", "5.51879516`", "65.086`", "\<\"\"\>"},
    {"33", "5.58129115`", "72.218`", "\<\"\"\>"},
    {"33", "5.58133617`", "64.069`", "\<\"\"\>"},
    {"33", "5.58141721`", "64.471`", "\<\"\"\>"},
    {"32", "5.5741921`", "48.199`", "\<\"\"\>"},
    {"32", "5.57428214`", "46.212`", "\<\"\"\>"},
    {"31", "5.50634217`", "56.78`", "\<\"\"\>"},
    {"31", "5.50650726`", "59.413`", "\<\"\"\>"},
    {"26", "5.4574`", "\<\"\"\>", "\<\"no ringdown\"\>"},
    {"21", "5.72506603`", "46.016`", "\<\"\"\>"},
    {"21", "5.7252061`", "51.925`", "\<\"\"\>"},
    {"20", "5.83`", "\<\"\"\>", "\<\"no ringdown\"\>"},
    {"19", "5.877`", "\<\"\"\>", "\<\"no ringdown\"\>"},
    {"17", "5.93`", "\<\"\"\>", "\<\"may be a localized mode, but low Q\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194888973`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7329458426740303`*^9, 
   3.7329483194888973`*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental data plots", "Subsection",
 CellChangeTimes->{{3.713840009211445*^9, 3.7138400235676394`*^9}, {
  3.71384133834262*^9, 3.7138413614365807`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"blueColors", "=", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {CMYKColor[1., 0., 0., 0.25], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->CMYKColor[1., 0., 0., 0.5],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "CMYKColor[1., 0., 0., 0.25]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           CMYKColor[1., 0., 0., 0.25]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["CMYKColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      CMYKColor[1., 0., 0., 0.25],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {CMYKColor[1., 0.13999999999999999`, 0., 0.25], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->CMYKColor[1., 0.1399999999999999, 0., 0.5],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "CMYKColor[1., 0.13999999999999999, 0., 0.25]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           CMYKColor[1., 0.13999999999999999`, 0., 0.25]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["CMYKColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      CMYKColor[1., 0.13999999999999999`, 0., 0.25],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {CMYKColor[1., 0.27999999999999997`, 0., 0.25], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->CMYKColor[1., 0.2799999999999998, 0., 0.5],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "CMYKColor[1., 0.27999999999999997, 0., 0.25]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           CMYKColor[1., 0.27999999999999997`, 0., 0.25]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["CMYKColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      CMYKColor[1., 0.27999999999999997`, 0., 0.25],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {CMYKColor[1., 0.42000000000000004`, 0., 0.25], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->CMYKColor[1., 0.41999999999999993`, 0., 0.5],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "CMYKColor[1., 0.42000000000000004, 0., 0.25]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           CMYKColor[1., 0.42000000000000004`, 0., 0.25]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["CMYKColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      CMYKColor[1., 0.42000000000000004`, 0., 0.25],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {CMYKColor[1., 0.5599999999999999, 0., 0.25], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->CMYKColor[1., 0.5599999999999998, 0., 0.5],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "CMYKColor[1., 0.5599999999999999, 0., 0.25]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           CMYKColor[1., 0.5599999999999999, 0., 0.25]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["CMYKColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      CMYKColor[1., 0.5599999999999999, 0., 0.25],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {CMYKColor[1., 0.7, 0., 0.25], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->CMYKColor[1., 0.6999999999999997, 0., 0.5],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "CMYKColor[1., 0.7, 0., 0.25]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           CMYKColor[1., 0.7, 0., 0.25]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["CMYKColorValueSelector"], {
             0, {Left, Bottom}}, {Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      CMYKColor[1., 0.7, 0., 0.25],
      Editable->False,
      Selectable->False]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"redColors", "=", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6666666666666667, 0.3032679738562092, 0.16993464052287582`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1., 0.4549019607843137, 0.2549019607843137]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[1., 0.4549019607843137, 0.2549019607843137]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1., 0.4549019607843137, 0.2549019607843137],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549],
            RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.6290196078431373, 0.18405228758169934`, 0.10405228758169935`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.8870588235294117, 0.09725490196078429, 0.05725490196078431], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.5913725490196078, 0.06483660130718953, 0.03816993464052287],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.8870588235294117, 0.09725490196078429, \
0.05725490196078431]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.8870588235294117, 0.09725490196078429, 0.05725490196078431]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.8870588235294117, 0.09725490196078429, 0.05725490196078431],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.7788235294117646, 0.034509803921568646`, 0.034509803921568646`], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.5192156862745098, 0.02300653594771243, 0.02300653594771243],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.7788235294117646, 0.034509803921568646, \
0.034509803921568646]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.7788235294117646, 0.034509803921568646`, 0.034509803921568646`]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[
      0.7788235294117646, 0.034509803921568646`, 0.034509803921568646`],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.6188235294117647, 0.08784313725490198, 0.08784313725490198], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.4125490196078431, 0.058562091503267986`, 0.058562091503267986`],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.6188235294117647, 0.08784313725490198, \
0.08784313725490198]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.6188235294117647, 0.08784313725490198, 0.08784313725490198]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.6188235294117647, 0.08784313725490198, 0.08784313725490198],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[
           0.4588235294117647, 0.1411764705882353, 0.1411764705882353], 
           RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[
          0.3058823529411765, 0.09411764705882353, 0.09411764705882353],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0.4588235294117647, 0.1411764705882353, \
0.1411764705882353]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = 
           RGBColor[
            0.4588235294117647, 0.1411764705882353, 0.1411764705882353]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0.4588235294117647, 0.1411764705882353, 0.1411764705882353],
      Editable->False,
      Selectable->False]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frameOptions", "=", 
   RowBox[{"Sequence", "[", 
    RowBox[{
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"\"\<Arial\>\"", ",", "10"}], "]"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {GrayLevel[0], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->GrayLevel[0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "GrayLevel[0]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["GrayLevelColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         GrayLevel[0],
         Editable->False,
         Selectable->False], ",", 
        RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7329462872108493`*^9, 3.7329463482020903`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"QDataSets", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"SelectFullQEntries", "[", 
      RowBox[{"QDataTable", ",", 
       RowBox[{"QThreshold", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataTable", ",", "QDataTables"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.711463415351862*^9, 3.7114634817412925`*^9}, {
   3.7114635881643047`*^9, 3.7114636014523635`*^9}, {3.7120331386004105`*^9, 
   3.7120331508683605`*^9}, {3.712033217150267*^9, 3.712033264871915*^9}, {
   3.7136115375052404`*^9, 3.713611550039268*^9}, {3.7136115898213882`*^9, 
   3.7136116045559254`*^9}, 3.713614377122243*^9, 3.713840517918214*^9, {
   3.7138412179842997`*^9, 3.713841220516032*^9}, {3.7138412597421575`*^9, 
   3.71384128509925*^9}, {3.7138414239792156`*^9, 3.713841436051214*^9}, {
   3.7138414694403205`*^9, 3.71384147491203*^9}},
 ExpressionUUID -> "7446f3f0-a65b-4b16-b0cd-2dcba7c5a083"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"average", " ", "Q"}], "-", 
    RowBox[{"factors", " ", "over", " ", "beams"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"QDataSetsAvg", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"AverageQFactors", "[", 
       RowBox[{"QData", ",", "0.05"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"QData", ",", "QDataSets"}], "}"}]}], "]"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.713614418039053*^9, 3.71361446917865*^9}, {
   3.713614570206264*^9, 3.713614615823589*^9}, {3.7136167275998454`*^9, 
   3.7136169078491454`*^9}, {3.7136170715553107`*^9, 
   3.7136171003605475`*^9}, {3.713617493319521*^9, 3.7136175066499767`*^9}, {
   3.7138424297568493`*^9, 3.7138425195214615`*^9}, {3.7138429107577825`*^9, 
   3.7138429120137825`*^9}, {3.714988881529149*^9, 3.71498888533834*^9}, {
   3.7149894609487653`*^9, 3.7149894718636804`*^9}, 3.71499257088868*^9, 
   3.714992606283535*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"QvsfListsExp", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"QDataAvg", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataAvg", ",", "QDataSetsAvg"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QfvsfListsExp", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"QDataAvg", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"QDataAvg", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], " ", 
         RowBox[{
          RowBox[{"QDataAvg", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "3"}], "]"}], "]"}], "/", "100."}]}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataAvg", ",", "QDataSetsAvg"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7138426999112034`*^9, 3.7138428131489077`*^9}, 
   3.713842855242285*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"QDataSetsAvg", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", ";;", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"blueColors", "[", 
       RowBox[{"[", 
        RowBox[{";;", "3"}], "]"}], "]"}], ",", "redColors"}], "]"}]}], ",", 
   "frameOptions", ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", "rawDataDirList"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7149895435857306`*^9, 3.7149895637774086`*^9}, {
   3.71499132740189*^9, 3.7149913629590316`*^9}, {3.7149914082337055`*^9, 
   3.714991460214899*^9}, {3.714991648276526*^9, 3.714991649059449*^9}, 
   3.7329463555424724`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0., 0., 0.25]], 
        PointBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAARL5LqUvm9z/LLRN6vLsWQJENpItN
y/c/KygcZgbGFEAtBg/Tvmn3P2+FCMyjBxNAR5OLMbAu9z+7cDYJVBQTQGmL
a3wm6/Y/NgkWqdD/E0AWURN9Por2P4QvCxebhBVAHOviNhow9j+WAr2jVJQW
QHegTnl0o/U/x3MqWajSFkDusfShCzL1P3x1faEjRBRAjPUNTG789D9KGrKn
9XAXQDCeQUP/xPQ/GWj0oWHiEkANqaJ4lX30P6/UlANT+BBAHozYJ4Bq9D/C
pQk8Vt4EQENyMnGraPQ/RyP28CYsB0B8JvvnaUj0P42AlFmkxwtAIUCGjh0k
9D8C26qi0L8VQOLaSI9kHfQ/OiAVOxfgEUAFpP0PsPbzPwfWSLfccBJAUYTU
7ezr8z+59w92Sf8RQMmTpGsmR/M/AUBgCtWaDkD/klSmmBPzPwko474CvglA
sP6XjQ==
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0.13999999999999999`, 0., 0.25]], 
        PointBox[{{1.96045275, 1.7993763901926663`}, {1.955058125, 
         1.8563229981779283`}, {1.79466675, 3.068985357037359}, {1.765293, 
         5.11674744500552}, {1.720007, 5.076387414773912}, {1.693850375, 
         4.9049035465774455`}, {1.66247475, 2.9016418159859723`}, {1.662068, 
         2.9991671406379723`}, {1.65087325, 2.9076750209179596`}, {1.6453775, 
         3.966166778568253}, {1.6430535, 3.9032554547366622`}, {1.6311665, 
         2.825533028144941}, {1.615018125, 2.4640865793220152`}, {1.42762625, 
         2.0970977607164825`}, {1.3645725, 2.0826263854266003`}, {1.258452625,
          1.7776847416484385`}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0.27999999999999997`, 0., 0.25]], 
        PointBox[{{1.93299625, 5.066956054869479}, {1.9221045, 
         5.327308235215739}, {1.901173625, 5.396930112780502}}]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[1., 0.4549019607843137, 0.2549019607843137]], 
        PointBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAjlNbh/ajB0CZLMBYnLkSQBYgwNgx
hAdAG2pkrgYSE0A/JJWMEGgHQDVeEJqDkBNAGoxLNMxVB0D4upkCl3oTQBeS
3RZ2OgdAbddGf9PvEkDMlPft+yIHQA8MZo3CgxJAoZ6hLDoVB0Bj18keXzoU
QOUjzi/v+gZAVotAgj4lFEByl+3YQsMGQOOYPQmxNhBAIWaCI3mtBkDsSklw
7FIGQJA+RKYkgAZAoQpHOU+iFECmwNkYAX4GQMIghrCqXxVAbW1lsk1cBkBn
pgrrlCAMQOwUaeqOEAZA2g2FhuiaEUBWPpFIVxAGQFjix2YtDBVAsdnTBg71
BUCdnCC/XhsRQEkXiIvJ6AVAytkw+TUkFUArxwFHRNUFQON4yvvg9xVAQs3V
Lwy3BUBvVvLF76kVQCIOyBRiVAVAE5k7q5LLEkBITbuYZkYFQHKORhihdxRA
Q2QFffEiBUDy3NLYJJMNQGopxTMNAQVAOVg85oyFE0ByVsAUUP4EQH/d+Mrx
HxRAYNrkri39BEB8siPDk4ATQB9LoN8=
         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549]], 
        PointBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAxGmYDI2ICUDFmjBJfcsOQG7spzlY
DwlATBu7fFLpEUDHoI8JYwEJQO6ixj10qBFAOG5K3NfzCEBWE4wo9TQUQL78
LYUwyAhAKiu4ImoFFEDGqTF8n6kIQH23KMFomRJAqF+3Qjd/CECJ22hKmB8Q
QNoEtWuELghACKjYLoPEE0CMSk0v790HQC3l/HUbXBRA6k/q5G+/B0BKj2HW
zHkUQGCcMhbRqwdAdCQfeY2gEkBsRXrV848HQI9EUatYZxNAPEY/O1yGB0Ck
pc8VMvEUQFzhy7KVZQdArX7eIxoAFkBCMvS6CxUHQBEp5JcT2xNANPCCDA0J
B0APU5p0N3oUQJU/CJZd5wZAOPQDnxkzCECTENUpybkGQFaqhMC6nRFA9ygz
EJGrBkA+9PGExG0QQH0RREijgwZAVMZgIYpNEEBKvFU6zE0GQD+9/1Oqlg9A
/2/TPNOdBUCYI/xB8CcUQEQ9Emn6lAVAf4kwgvlCEkCOz2T/PHUFQPG9RHSV
4BNAxr1cOM5NBUBlhtV3qa4TQC0xpssoLwVAlLwC8m54EUCM0J2aqicFQPkI
MXj+yhNAIxbvz14IBUDaK2QHMpoMQKnL98bv/QRAfDv1Gkv3EUCmOk8CvOkE
QIq8u/hNRApAXf8ql/iZBEBnadgsPegCQB1h5nWjewRAEOYLd1Vg/j8AIdMS

         "]]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[
         0.8870588235294117, 0.09725490196078429, 0.05725490196078431]], 
        PointBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAArHoSO8cuC0DMeG4kxGkTQMqp+Brd
DAtAmgUL2qkoFUD6dkq7XOoKQMq2U7TwghVA9K3ma1yECkDK0jH6tn0VQDXZ
FtDRcwpAWngnO9oTE0BFH3RRdWAKQPBk/yLPCxVAPic8IIhbCkBek11RcFQU
QDVGZ3DGQgpABKvi8JexE0AqF9qf4B0KQAsemjfCkxRAnls7+BsOCkCwTlid
ghEXQCtGRM5O1AlAo1SyAYcVFkAyj9uz15wIQPGZv/6QTxNAGrhuEM53CEBW
WeU4p9ESQEmg4rS3ZghAOXbdrpy3B0C6tchNP14IQHvzzb/iRxNA2SFhjAZE
CECk+v82SBYUQMJqyTayBwhAOKYkUDLKEEBBu0OKAQIIQIZ/S3ug8BJAwCqT
8VrbB0DEj5yLD9URQBWvLn6FogdA7uMB/oUlEUCQDeanH5UHQL3H437LHxBA
Vq+Meg==
         "]]}, {
        Hue[0.08640786499873876, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[
         0.7788235294117646, 0.034509803921568646`, 0.034509803921568646`]], 
        PointBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAadJ9a+1eDkDq32KCWrsFQJsvQOyW
Vg5AVqE7fFtQBEDxzql9nSgOQGgzYH9lTA9A43J65v4dDkAXTR1//LsMQAyT
BDzEng1ATLrjqmzzEkAoELA13wENQBeakldZuhBA5gZ9yN/sDEAvPQH+bA0V
QGpTKwJS0QxA/JDmSTGKE0CH3Vb+pWIMQC0FwBeNJgFA1uUQSPQgDEAiKq/r
TcASQKL9WT1xCgxAg/+3200dCEBBTpC/Ub4LQObqLx8bvhFA4s+NPFK5C0Dk
0uxs6QsVQAaMPLK2sQtAO0WxidvYFEDpIir5fXQLQIsXQH6k3BFAXrAjJ3Y5
C0Czm86CC8QUQHhtwv9O2QlAtFQSUSGHEkBEXXvR5KMJQMXFNCqQBBNAVnbq
X8yNCUBvYxmyT00SQC10qTp5iwlA40x+zMrGEkBeXHAnjXAJQFQfrClh1A1A
OUjjq3i+CEAbzb/F2FgJQMDDkrU=
         "]]}, {
        Hue[0.3224758424985268, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6188235294117647, 0.08784313725490198, 0.08784313725490198]], 
        PointBox[{{5.725136065, 3.8912180759949577`}, {5.581348176666666, 
         4.203487913925147}, {5.57423712, 3.854510411226679}, {
         5.518743883333333, 4.194451300931378}, {5.506424715, 
         4.06210542107945}, {5.49751791, 3.987482920438007}, {
         5.436610549999999, 4.252017602675652}, {5.4362409, 
         4.656199112100095}, {5.42640628, 4.586107135137818}, {5.36065438, 
         4.492785055393301}, {5.36033267, 
         1.631199404215613}}]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, 
     AxesOrigin -> {1.1214584403906251`, 1.324247676318211}, 
     PlotRange -> {{1.19228425, 5.725136065}, {1.3962486989114284`, 
      5.860312099690939}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.1214584403906251`, 1.324247676318211}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.19228425, 5.725136065}, {1.3962486989114284`, 
      5.860312099690939}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"2017-09-15 UQ31_stress_14cell_4mm\"", 
       "\"2017-09-19 UQ31_4mm_18unitcell\"", 
       "\"2017-09-20 UQ31_4mm_20unitcell\"", 
       "\"2017-09-20 UQ31_stress_28cell_4mm\"", 
       "\"2017-09-19 UQ31_stress_30cell_4mm\"", 
       "\"2017-09-05 UQ31_stress_34cell_4mm\"", 
       "\"2017-09-08 UQ31_stress_36cell_4mm\"", 
       "\"2017-10-10 UQ35_stress_59cell_4mm\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0., 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0., 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 
                    0.156078431372549]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 
                    0.156078431372549]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #8}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0., 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> CMYKColor[1., 0., 0., 0.5], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0., 0., 0.25]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0., 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0., 0., 0.25], Editable -> False, 
                    Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    CMYKColor[1., 0.1399999999999999, 0., 0.5], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0.13999999999999999, 0., 0.25]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    CMYKColor[1., 0.2799999999999998, 0., 0.5], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0.27999999999999997, 0., 0.25]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6666666666666667, 0.3032679738562092, 
                    0.16993464052287582`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1., 0.4549019607843137, 0.2549019607843137]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6290196078431373, 0.18405228758169934`, 
                    0.10405228758169935`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.9435294117647058, 0.276078431372549, \
0.156078431372549]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549],
                     Editable -> False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5913725490196078, 0.06483660130718953, 
                    0.03816993464052287], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.8870588235294117, 0.09725490196078429, \
0.05725490196078431]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5192156862745098, 0.02300653594771243, 
                    0.02300653594771243], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.7788235294117646, 0.034509803921568646, \
0.034509803921568646]"], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.4125490196078431, 0.058562091503267986`, 
                    0.058562091503267986`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.6188235294117647, 0.08784313725490198, \
0.08784313725490198]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "False", ",", "False", ",", "False", ",", "False", ",", 
                 "False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.714989550089841*^9, 3.714989564043166*^9}, 
   3.71499138078615*^9, 3.714991415426072*^9, 3.714991460599638*^9, 
   3.714991650526924*^9, 3.714992574095858*^9, 3.7149926088601646`*^9, 
   3.717427278134901*^9, 3.732945878742401*^9, 3.7329463572271767`*^9, 
   3.732948332114647*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nMax", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvsfMaxExp4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"MaximalBy", "[", 
      RowBox[{"QvsfList", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}], ",", "nMax"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QvsfList", ",", "QvsfListsExp"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QfvsfMaxExp4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"MaximalBy", "[", 
      RowBox[{"QfvsfList", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}], ",", "nMax"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QfvsfList", ",", "QfvsfListsExp"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.713848023417819*^9, 3.713848139935424*^9}, {
   3.7138483054993057`*^9, 3.713848315854102*^9}, {3.714991512569135*^9, 
   3.714991627426943*^9}, {3.7174283655301714`*^9, 3.7174283656128774`*^9}, {
   3.7174284072283173`*^9, 3.7174284224657087`*^9}, {3.71861783785819*^9, 
   3.718617849554066*^9}, 3.732948281870282*^9, {3.7329483384431553`*^9, 
   3.7329483386432*^9}},
 CellID->11232736],

Cell[BoxData[
 TemplateBox[{
  "MaximalBy","dstlms",
   "\"The requested number of elements \\!\\(\\*RowBox[{\\\"6\\\"}]\\) is \
greater than the number of elements \\!\\(\\*RowBox[{\\\"3\\\"}]\\). Only \\!\
\\(\\*RowBox[{\\\"3\\\"}]\\) elements will be returned.\"",2,28,7,
   30057862990260586904,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7329483321680393`*^9, 3.732948403502236*^9}],

Cell[BoxData[
 TemplateBox[{
  "MaximalBy","dstlms",
   "\"The requested number of elements \\!\\(\\*RowBox[{\\\"6\\\"}]\\) is \
greater than the number of elements \\!\\(\\*RowBox[{\\\"3\\\"}]\\). Only \\!\
\\(\\*RowBox[{\\\"3\\\"}]\\) elements will be returned.\"",2,29,8,
   30057862990260586904,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7329483321680393`*^9, 3.7329484035455484`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"QvsfMaxExp4mm", ",", "1"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ">", "60"}], "&"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0.9", " ", 
         SuperscriptBox["10", "1"]}], ",", 
        SuperscriptBox["10", "3"]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Blue", "}"}]}], ",", "frameOptions", ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", "\"\<4mm beams\>\"", "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Present manuscript plot:\\n4mm beams, post-selected 6 highst Q's per \
chip\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7186171268356237`*^9, {3.7186171735849233`*^9, 3.7186171776686373`*^9}, {
   3.7186172362468653`*^9, 3.718617258204007*^9}, {3.7186173206214237`*^9, 
   3.718617365340135*^9}, {3.718617395766927*^9, 3.7186173962241473`*^9}, {
   3.7186175252283673`*^9, 3.7186175413980503`*^9}, {3.718617866957368*^9, 
   3.718617869351042*^9}, {3.7186180448863916`*^9, 3.718618061589876*^9}, {
   3.71861813367107*^9, 3.718618207027895*^9}, {3.7186185111904726`*^9, 
   3.7186185316326785`*^9}, {3.7186185623044662`*^9, 3.718618596592047*^9}, {
   3.7329483471470213`*^9, 3.7329483999987917`*^9}, {3.7329484862826624`*^9, 
   3.7329484896489763`*^9}, {3.732948531377468*^9, 3.732948537455771*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1]], 
        PointBox[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAAjPUNTG789D9KGrKn9XAXQHegTnl0
o/U/x3MqWajSFkBEvkupS+b3P8stE3q8uxZAHOviNhow9j+WAr2jVJQWQCFA
ho4dJPQ/AtuqotC/FUAWURN9Por2P4QvCxebhBVAQblt36M+/D/VwmikjHcU
QNVBXg8mhfs/qB6hgDhOFEDPE8/ZAhr7P5JWCgmfnhNAx0j2CDVr/j9nwvTY
dJYVQDLp76XwwP4/MNrX4ylPFUB2ptB5je3+PwC8xyCQRBRAK8cBR0TVBUDj
eMr74PcVQELN1S8MtwVAb1byxe+pFUCmwNkYAX4GQMIghrCqXxVASReIi8no
BUDK2TD5NSQVQFY+kUhXEAZAWOLHZi0MFUCQPkSmJIAGQKEKRzlPohRAXOHL
spVlB0Ctft4jGgAWQDxGPztchgdApKXPFTLxFEA08IIMDQkHQA9TmnQ3ehRA
6k/q5G+/B0BKj2HWzHkUQIxKTS/v3QdALeX8dRtcFEA4bkrc1/MIQFYTjCj1
NBRAnls7+BsOCkCwTlidghEXQCtGRM5O1AlAo1SyAYcVFkD6dkq7XOoKQMq2
U7TwghVA9K3ma1yECkDK0jH6tn0VQMqp+BrdDAtAmgUL2qkoFUBFH3RRdWAK
QPBk/yLPCxVA5gZ9yN/sDEAvPQH+bA0VQOLPjTxSuQtA5NLsbOkLFUAGjDyy
trELQDtFsYnb2BRAXrAjJ3Y5C0Czm86CC8QUQGpTKwJS0QxA/JDmSTGKE0BE
XXvR5KMJQMXFNCqQBBNA3rU677W+FUBeifio8p8SQNaiDdmjtBVAC3oFeCxY
EkBgCb1hT3EVQLN8Q6Wc+BFAsloF1ha/FUByCAbnEAIRQIF9ue9MUxZAU8K9
Il/QEEC1qreYMRMWQOKo6D0exxBAsxggow==
         "]]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, 
     AxesOrigin -> {0, 2.2207772308444493`}, PlotRange -> 
     NCache[{{0, 6}, {2.1972245773362196`, 
         Log[1000]}}, {{0, 6}, {2.1972245773362196`, 6.907755278982137}}], 
     PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
     Identity, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {None, None}, 
     AxesOrigin -> {0, 2.2207772308444493`}, DisplayFunction :> Identity, 
     Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Present manuscript plot:\\n4mm beams, post-selected 6 highst \
Q's per chip\"", TraditionalForm], PlotRange -> 
     NCache[{{0, 6}, {2.1972245773362196`, 
         Log[1000]}}, {{0, 6}, {2.1972245773362196`, 6.907755278982137}}], 
     PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
     Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"4mm beams\""}, "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                 ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                  False]}], "]"}], "}"}], ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", "False", "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7329483322835383`*^9, {3.732948400774468*^9, 3.7329484074219046`*^9}, 
   3.732948490401637*^9, {3.7329485334984355`*^9, 3.732948538303132*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Separate plots by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["N", "UC"], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Subsection",
 CellChangeTimes->{{3.7329478782623105`*^9, 3.7329478991965437`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"\"\<Measurement folder name: \>\"", "~~", 
         RowBox[{"rawDataDirList", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", "Bold", ",", "14"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\[IndentingNewLine]", 
      RowBox[{"ListLogPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"QDataSets", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", ";;", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
          RowBox[{"QDataSetsAvg", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", ";;", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
        RowBox[{"Joined", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"False", ",", "True", ",", "True"}], "}"}]}], ",", 
        "frameOptions", ",", 
        RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<f [MHz]\>\"", ",", 
           "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], 
          "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<raw data\>\"", ",", "\"\<averaged\>\""}], "}"}]}]}], 
       "]"}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<\\n\>\"", "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "QDataSets", "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7114635329953423`*^9, 3.7114636076370525`*^9}, 
   3.71146377283038*^9, 3.7120331652140512`*^9, {3.71361438616298*^9, 
   3.7136143939598866`*^9}, {3.713617107829365*^9, 3.713617122965357*^9}, {
   3.71361729242432*^9, 3.7136173335715065`*^9}, {3.7138425590735626`*^9, 
   3.713842566276472*^9}, {3.7138428853991795`*^9, 3.713842974078097*^9}, {
   3.713843010068701*^9, 3.7138431013958206`*^9}, {3.7149894868611107`*^9, 
   3.714989492405052*^9}, {3.732946378532598*^9, 3.732946383690279*^9}},
 ExpressionUUID -> "cf72089c-9e61-45e8-b8a9-61308caccc19"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-15 UQ31_stress_14cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.73294850107452*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAARL5LqUvm9z/LLRN6vLsWQJENpItN
y/c/KygcZgbGFEAtBg/Tvmn3P2+FCMyjBxNAR5OLMbAu9z+7cDYJVBQTQGmL
a3wm6/Y/NgkWqdD/E0AWURN9Por2P4QvCxebhBVAHOviNhow9j+WAr2jVJQW
QHegTnl0o/U/x3MqWajSFkDusfShCzL1P3x1faEjRBRAjPUNTG789D9KGrKn
9XAXQDCeQUP/xPQ/GWj0oWHiEkANqaJ4lX30P6/UlANT+BBAHozYJ4Bq9D/C
pQk8Vt4EQENyMnGraPQ/RyP28CYsB0B8JvvnaUj0P42AlFmkxwtAIUCGjh0k
9D8C26qi0L8VQOLaSI9kHfQ/OiAVOxfgEUAFpP0PsPbzPwfWSLfccBJAUYTU
7ezr8z+59w92Sf8RQMmTpGsmR/M/AUBgCtWaDkD/klSmmBPzPwko474CvglA
sP6XjQ==
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAQ3Iycato9D9HI/bwJiwHQHwm++dp
SPQ/jYCUWaTHC0CloUYhyRz0P5HE/86MfBJApHGo34Ud9D+ZrC0lNIIRQF59
66zeHfQ/qDKvAoSNEUAFpP0PsPbzPwfWSLfccBJA/5JUppgT8z8JKOO+Ar4J
QFGE1O3s6/M/ufcPdkn/EUDJk6RrJkfzPwFAYArVmg5AIUCGjh0k9D8C26qi
0L8VQB6M2CeAavQ/wqUJPFbeBEANqaJ4lX30P6/UlANT+BBAjPUNTG789D9K
GrKn9XAXQO6x9KELMvU/fHV9oSNEFEB3oE55dKP1P8dzKlmo0hZAMJ5BQ//E
9D8ZaPShYeISQBzr4jYaMPY/lgK9o1SUFkAWURN9Por2P4QvCxebhBVAaYtr
fCbr9j82CRap0P8TQEeTizGwLvc/u3A2CVQUE0AtBg/Tvmn3P2+FCMyjBxNA
RL5LqUvm9z/LLRN6vLsWQJENpItNy/c/KygcZgbGFECxJKgz
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {1.18757424609375, 2.3725488632009717`},
      PlotRange -> {{1.19228425, 1.4937245}, {2.427910184415098, 
      5.860312099690939}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.18757424609375, 2.3725488632009717`}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.19228425, 1.4937245}, {2.427910184415098, 
      5.860312099690939}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485011276245`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.73294850132729*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_4mm_18unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948501342907*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1.96045275, 1.7993763901926663`}, {1.955058125, 
         1.8563229981779283`}, {1.79466675, 3.068985357037359}, {1.765293, 
         5.11674744500552}, {1.720007, 5.076387414773912}, {1.693850375, 
         4.9049035465774455`}, {1.66247475, 2.9016418159859723`}, {1.662068, 
         2.9991671406379723`}, {1.65087325, 2.9076750209179596`}, {1.6453775, 
         3.966166778568253}, {1.6430535, 3.9032554547366622`}, {1.6311665, 
         2.825533028144941}, {1.615018125, 2.4640865793220152`}, {1.42762625, 
         2.0970977607164825`}, {1.3645725, 2.0826263854266003`}, {1.258452625,
          1.7776847416484385`}}]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[{{1.615018125, 2.4640865793220152`}, {1.42762625, 
         2.0970977607164825`}, {1.6453775, 3.966166778568253}, {1.258452625, 
         1.7776847416484385`}, {1.3645725, 2.0826263854266003`}, {1.662068, 
         2.9991671406379723`}, {1.6311665, 2.825533028144941}, {1.65087325, 
         2.9076750209179596`}, {1.955058125, 1.8563229981779283`}, {
         1.66247475, 2.9016418159859723`}, {1.693850375, 
         4.9049035465774455`}, {1.720007, 5.076387414773912}, {1.96045275, 
         1.7993763901926663`}, {1.765293, 5.11674744500552}, {1.79466675, 
         3.068985357037359}, {1.6430535, 
         3.9032554547366622`}}]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, 
     AxesOrigin -> {1.2474838730468754`, 1.5353334164047796`}, 
     PlotRange -> {{1.258452625, 1.96045275}, {1.5921812581286008`, 
      5.11674744500552}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.2474838730468754`, 1.5353334164047796`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.258452625, 1.96045275}, {1.5921812581286008`, 
      5.11674744500552}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485016015124`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485016015124`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_4mm_20unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485016015124`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1.93299625, 5.066956054869479}, {1.9221045, 
         5.327308235215739}, {1.901173625, 5.396930112780502}}]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[{{1.93299625, 5.066956054869479}, {1.922092, 
         5.231827702101076}, {1.922117, 5.414461551132426}, {1.901173625, 
         5.396930112780502}}]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {1.9006763964843754`, 5.04173388175362},
      PlotRange -> {{1.901173625, 1.93299625}, {5.047650193965982, 
      5.414461551132426}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.9006763964843754`, 5.04173388175362}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.901173625, 1.93299625}, {5.047650193965982, 
      5.414461551132426}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485017128963`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485018973827`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_stress_28cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485018973827`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAjlNbh/ajB0CZLMBYnLkSQBYgwNgx
hAdAG2pkrgYSE0A/JJWMEGgHQDVeEJqDkBNAGoxLNMxVB0D4upkCl3oTQBeS
3RZ2OgdAbddGf9PvEkDMlPft+yIHQA8MZo3CgxJAoZ6hLDoVB0Bj18keXzoU
QOUjzi/v+gZAVotAgj4lFEByl+3YQsMGQOOYPQmxNhBAIWaCI3mtBkDsSklw
7FIGQJA+RKYkgAZAoQpHOU+iFECmwNkYAX4GQMIghrCqXxVAbW1lsk1cBkBn
pgrrlCAMQOwUaeqOEAZA2g2FhuiaEUBWPpFIVxAGQFjix2YtDBVAsdnTBg71
BUCdnCC/XhsRQEkXiIvJ6AVAytkw+TUkFUArxwFHRNUFQON4yvvg9xVAQs3V
Lwy3BUBvVvLF76kVQCIOyBRiVAVAE5k7q5LLEkBITbuYZkYFQHKORhihdxRA
Q2QFffEiBUDy3NLYJJMNQGopxTMNAQVAOVg85oyFE0ByVsAUUP4EQH/d+Mrx
HxRAYNrkri39BEB8siPDk4ATQB9LoN8=
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJwV0n9Qk3UcB/Dx43ke4sfG9jzPPPAHA9GLQplFtSOR9xkuNvIgcIgLCRDZ
OEBs6JQaUhwlBYiXWGd5piJ4cGHoZQsuFMHEg8NBhMAFhm6B5JLIgbAZ9O2P
z73v9d/7ffcJzipM2usuEAgU5P5PQ0oHl7jkidLxhZ7ZIA5FFy2577lRWOHy
MA3EsKAkrnPriFMz7/aFJLBQsssPfhdQSEr6YP5TMwv7iHqinfgNdXB+yW0W
PUupvm/+6wm5vS78ro2FySuhejNxd8emBc9UFqNH6SKK+HWn72sDm1mMnVk+
7wihIEzL+qLNyw9NYT47HxOXWdfIejkhjv1a1JquJB78wxCr5eBxy/3wPmJm
Pj8yvJbDKcOB+MwdFGQOxbnaIQmaGlfeyyLWWdbkH7ohwfP77LGiIQq7+y1z
bc08Esz6ES3x11O+B380SrGlpfPyTuLLIuf28z/zmFPOvJVA/HCx88T2aR5P
tnhfCjVTqNFZLKtlUnQuSu+sIjZPfDbwHM+Dj8hgrT9QUCrcmDAzj2Oaqke3
HlKQyitkKTYOL2w9O/0bcXybK/eMhkfopby+VuKtzeVjRRE8igXfetscFDZO
xRTLdosxfcXlrpij0DizLidgyB+6VZGUyZ9GRHK/McfJYVvG48qXiB8cvd3c
sJrH5Kjigoq45++mwN40Mb6Ze8etgfipVXg61iYGChsC2onLm6obBZVibLKo
tbMlNK4dCdIMqHisvKIf9j9CozqqTS46yENpmDDEpdHwy6MVe677oFb/52wS
8cT6k9J3S3zRu/8f8VQp6aNmE+VkD1oOh0Z/SOOUR0zOsopD/VeZP6mIxR1h
k0vhHIJzytYWN9Owq1X77Uk0svOyHRFdNLTd5dmLDhE+6jK2a4h3db28o7rQ
HzcCK+47QxgsTIz2F3wswYhQ53xGHLsh80tpmQQtz677DDtpRHcsdMeJOATG
jyUzLhrztrjIa1Ec0q3eWiHPAGXb/OISOdh2KZb3Ete/WFPlWsthxefjUmMU
g4JhZengjAT13998ZNQw6NYfivYi/3h8zy+m4BQGVSFWU+VVFvcO9ApndQye
zL89m3yaxdnBdG+5nkHrevl8TTmL7/4S1vfVMXgl9ebGT+5LUNB6MTfoAoPJ
gFaGOy5B5HjF+x7lDITGdI1bnQQLWU9fzSB2LF29s8HI4j/KIHDT
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {2.61836441734375, 2.5854171953837284`},
      PlotRange -> {{2.62354555, 2.95513804}, {2.6335207005916668`, 
      5.615938023483888}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {2.61836441734375, 2.5854171953837284`}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.62354555, 2.95513804}, {2.6335207005916668`, 
      5.615938023483888}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948501959886*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.73294850217486*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_stress_30cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485021944957`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAxGmYDI2ICUDFmjBJfcsOQG7spzlY
DwlATBu7fFLpEUDHoI8JYwEJQO6ixj10qBFAOG5K3NfzCEBWE4wo9TQUQL78
LYUwyAhAKiu4ImoFFEDGqTF8n6kIQH23KMFomRJAqF+3Qjd/CECJ22hKmB8Q
QNoEtWuELghACKjYLoPEE0CMSk0v790HQC3l/HUbXBRA6k/q5G+/B0BKj2HW
zHkUQGCcMhbRqwdAdCQfeY2gEkBsRXrV848HQI9EUatYZxNAPEY/O1yGB0Ck
pc8VMvEUQFzhy7KVZQdArX7eIxoAFkBCMvS6CxUHQBEp5JcT2xNANPCCDA0J
B0APU5p0N3oUQJU/CJZd5wZAOPQDnxkzCECTENUpybkGQFaqhMC6nRFA9ygz
EJGrBkA+9PGExG0QQH0RREijgwZAVMZgIYpNEEBKvFU6zE0GQD+9/1Oqlg9A
/2/TPNOdBUCYI/xB8CcUQEQ9Emn6lAVAf4kwgvlCEkCOz2T/PHUFQPG9RHSV
4BNAxr1cOM5NBUBlhtV3qa4TQC0xpssoLwVAlLwC8m54EUCM0J2aqicFQPkI
MXj+yhNAIxbvz14IBUDaK2QHMpoMQKnL98bv/QRAfDv1Gkv3EUCmOk8CvOkE
QIq8u/hNRApAXf8ql/iZBEBnadgsPegCQB1h5nWjewRAEOYLd1Vg/j8AIdMS

         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJwV0n9QkwUcx/Ex9ux5BiP37HkYZQaCBwKVCCM1E/cB1qV4E2mMbnFj6IIg
5UfIoh9HO3VwgJDLAW3eoSFG48fBdV6QORMQUUBd3EUNJup1KXWFkx+BpUBP
f3zve6//vnfvb+iBojdz+Dwe71Vu/t+/zt2ofr2JQNr+4TrLNhbrZia82acJ
mDLVPaIgFpW/XBmLrydgq5rycXsl+NO/IYFuIMBzvu96Sy3Fob2W08mcF9Ov
ypgtDOKv6Bf1nA3Rb2uvQ4p9J0VqbymBedGjgMRRBqPivo4aI4HzjQ2FH//N
IEZSxTOqCAy4tza7jjDQHYwt3riXwCFyoqh5gsHLsa2jkTEE6p38ucIPafiV
XhxrjSBQl5V779Y5KXq/0Y18tpHAUl9Prcafuz85qfYHzkFt5y5EWFn42KO8
Hs5j7pTz624ymJRYZsyRBO6HPz1c7WCwQeZ1ZVEEJl98h4w7JUZ8Sf7Ou8sC
/DY+oKl9RCM4vDKVtyKAYrPWurJMo3V7Kt/5hwA1zouPVUo/6Fajv3hsF+Dd
fPdLCb/z8cL+B8aWTwSQPPAv02SvKFKcmu03VEIoLq2q2xvXYClSLvm8Q4id
C7PmwQIJymnlrpZjQqQPZYfWqCSwSsajhi8IkdFu7vu+iUaDgmrUTQuxbcH3
zHNyCsEax/A0RULeOaB9w8Jiz3FdapyIRO9cWGyHgYWpRa++xZL413fatnCf
gaC/Kmx3IIkyoW83+yOD9bcblNYTJI6O3E4wZDLo7crKTbeQ8PC+7o8+zIAu
2BPAzyGRU1apWvAPRED08pCLc5rdBJlRhiXx80ov566c/E8NWhk2/JOyPryS
RFtmUuJ7/Sw0VnmGlbP02bkKd3AgcFJotHeQ4KflaoO4XqbWrF6qk0SJqbuU
1yRFc2FZot9lEuUV6QkZXJ+w1fzFo5xVX+1IS+1k8fTI1AcDnIVuW3fFXRbW
11pvOqdIKCLKZ/mRLMzaBUvoHRJbLvm80lXHYlLw7UHzJgqUw73p2CADh743
aauJQrUnL8UWIsFEVFH7gesU/Ee+U5HzDM66/tKvXKPg2XF59iPu31VxD6fS
2ijU259M5nH9FaHGtTOcf44JaS+IZjDmUPI98xSejCfHVexicUa+r+cnziVr
c+p9Q1lc+/KEyOAjwsOzQwmlDhrJeeLakDUiFHvIxO55Grbi5GkLZ+nIPfvk
HRqD+TZxXZUIV09t3l0++gz+Ay4wcNk=
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, 
     AxesOrigin -> {2.5505062307812496`, 1.6288221249909098`}, 
     PlotRange -> {{2.56037037, 3.19167528}, {1.6920843562917107`, 
      5.614342696941393}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {2.5505062307812496`, 1.6288221249909098`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.56037037, 3.19167528}, {1.6920843562917107`, 
      5.614342696941393}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485022595005`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948502475341*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-05 UQ31_stress_34cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948502475341*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAArHoSO8cuC0DMeG4kxGkTQMqp+Brd
DAtAmgUL2qkoFUD6dkq7XOoKQMq2U7TwghVA9K3ma1yECkDK0jH6tn0VQDXZ
FtDRcwpAWngnO9oTE0BFH3RRdWAKQPBk/yLPCxVAPic8IIhbCkBek11RcFQU
QDVGZ3DGQgpABKvi8JexE0AqF9qf4B0KQAsemjfCkxRAnls7+BsOCkCwTlid
ghEXQCtGRM5O1AlAo1SyAYcVFkAyj9uz15wIQPGZv/6QTxNAGrhuEM53CEBW
WeU4p9ESQEmg4rS3ZghAOXbdrpy3B0C6tchNP14IQHvzzb/iRxNA2SFhjAZE
CECk+v82SBYUQMJqyTayBwhAOKYkUDLKEEBBu0OKAQIIQIZ/S3ug8BJAwCqT
8VrbB0DEj5yLD9URQBWvLn6FogdA7uMB/oUlEUCQDeanH5UHQL3H437LHxBA
Vq+Meg==
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxFyWtMUwcAxXEkSm9voSu97W2VUBFf9RFKCFCwCT0gSCc2RsRKMBCcD9iy
tB1qLZMAAyZDRtVIt2mKIrJhw8pEtBUVJIAI2m6gWAQFNpROEfeKOpBt3fXL
9uHkn1/Okvd0qXt8fXx8Ypi9rTui4EqdhcDi339QWNdRMD1f951/DYFca0pT
wG4KaUrr/YcHCWT2bDx1/FM+xsMjUzoY53Ivy/LFFN6tnbjk2Esg1jDaZHGw
ML9w3qG0TAKqR1GndZ185D8JF5RnEaio+oCVZxTA3r4yY4KxY/6V+N/W87Fw
QO1qXE/AfmIowK+Xwsm8/Sk7EwnsDZXumssSQHM9bPMqFgGl5KxyroYH2cLd
EgVBoD7He6f6JQ/hf/9oN4+w0HgmmOMqDsTm9KS1IY9YUN08tuFZKB9dGT9/
XTqPwPKaZatbYvm4EVSrLfIlsPpavamnkkLjdL7fijoWtJEXdLQrEEUfPX71
hPGgf6knMJMHl1d2q6OaBUebK+HBUy7SgiyfFZpZeJUXUmm6yMNt68yiUX8O
Ti3gjFilQqQcNLe1PyMh18eQNpMQ575pGFZPkbjpbo34Zysf5bI3DQ3MnxSU
vkrVTmOTvnw44DkJcXOkrSCdxlLz5aNvfZ5yHOtQCWEwsFvFZSS0jj9br0kE
2DfZJallnGerDz1dQqM2Otnas4NETET+wzAIof+wvD+VsTNhRjY5Q8F2d9JT
yNi0AGcKjlOIGqb7B/aRyDCuVIxQFLYOyF+kZpP46eWGw7P3AsGtKlE0Mo7s
q5tdcUgInffsnZ2MvxivarIW0eDlbLPfDyYxtliTuXZUALnOIvAwVooq2uIG
/3elUM6WvKHQJUnaxeWSyA1JMMbHiaDZskU2xLjabXQakkVwWqa1jndI/Po0
9pcX/SJcP6nePsHYpyc58RMZDeXyJfrzPBK9Q3908y6KcPhAcYubsXrOGV3W
R2GTp+XLXsbuOG/L90eEuBuvfuxivM3r/GpNhfg/z04bKE4xjbmpiohEDonE
UfNRuU2E4e4L2Vo2CeuiWM1fV0XY06cxJDE+cjuredyPhq6k2c5jfC4qPrrX
LoK4NGvKlkCi0+RfNhYsQCpb/3qM8YAqhy6OofD6xgGp4x4ba9SdD6RSGtlO
/n7PIBvoE3Z/7kvj24/5ilthHDiN2mXd71P4F+VVbz8=
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {2.9405988259375, 2.734624402816405}, 
     PlotRange -> {{2.94763332, 3.39784094}, {2.788582037238229, 
      6.133955371391342}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {2.9405988259375, 2.734624402816405}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.94763332, 3.39784094}, {2.788582037238229, 
      6.133955371391342}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948502597316*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948502778201*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-08 UQ31_stress_36cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948502778201*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAadJ9a+1eDkDq32KCWrsFQJsvQOyW
Vg5AVqE7fFtQBEDxzql9nSgOQGgzYH9lTA9A43J65v4dDkAXTR1//LsMQAyT
BDzEng1ATLrjqmzzEkAoELA13wENQBeakldZuhBA5gZ9yN/sDEAvPQH+bA0V
QGpTKwJS0QxA/JDmSTGKE0CH3Vb+pWIMQC0FwBeNJgFA1uUQSPQgDEAiKq/r
TcASQKL9WT1xCgxAg/+3200dCEBBTpC/Ub4LQObqLx8bvhFA4s+NPFK5C0Dk
0uxs6QsVQAaMPLK2sQtAO0WxidvYFEDpIir5fXQLQIsXQH6k3BFAXrAjJ3Y5
C0Czm86CC8QUQHhtwv9O2QlAtFQSUSGHEkBEXXvR5KMJQMXFNCqQBBNAVnbq
X8yNCUBvYxmyT00SQC10qTp5iwlA40x+zMrGEkBeXHAnjXAJQFQfrClh1A1A
OUjjq3i+CEAbzb/F2FgJQMDDkrU=
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxF0n0s1HEcB/BzJX797o67353LsDxsJg9d7NYTtTdFWUSM0kk6UbL1gJRL
Rx67zMiclIbEYdpaNlGnU4zKstFGD07UleomYVaxqG//6I/P3nv9935vHwf5
qbB4NovF8iD3L3uPZ2Wav6HQkJWou3tBALfklVlq4h5vs5zkUgG8HPslrbcp
dMsUh+PmBIioWJcirKPQmnq3JEPIwCO1aWt6IQVDkPJFX68AFx7ZzmqKKCjH
GswMjQJ4Str7Z4jvPIVVxxc+Fr71tYSepiCdUW04mG6B7j7RzefEOzRBzPgT
Glt2G5rP68xh09/Z8/oAhcSXF5O+xfBgHJNnH9SaolKCyfJIHiJveWfIQlei
Zqe6OdGFhxUJLuLNXy3hF6ULGSResguRBl2jYUhWTCzZ8SAOtsv8reUgKdyN
HTbIwcg7mcb6EbPs8VFVR3T8f8/XZjtxFAyarRxnfNhczPqmHDGGWUJDbVdc
MuFi5JWzLHANH757Szr36WhMGCVrbXR8fHV0nb+YSqNQDGWdno85xUSl0z0a
Q0f8p9wWRSguO7aN1UIj7w17u+MIs+y3nVIoYoUIUOrZXlto+Fj7BeeKhWhl
uRUXEBvFtPtigAgOpXGGRuJP4yrbH8NC1FbqU1TtNGJn8zSqEAbKBfV3NfGM
yMFi46AInurqgS5ilb9xFzdfCHfl/eyjD2g0fSxP48vE6M75UGX9kPST1F3X
rxKCbmkQFRF3XeEM7WlgUDAauVQv58DD9LG4yNkEtYtR286s5iDnT9tIsJ05
vJ3qpT/sObiz1V7PS2aWHf7ULGPVez54SV9OThOfSMtPeEb+Q3s5zubxJAcV
3zfZtnmRPbG954aJu34FafcXMjg76jf3k7jx0JRGKrdCYETBjWli5/vtZVSR
EOlln4MLqrhoO62JWi9iUHPVwdWkmosKQXRM7oAAfwEC7ygf
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {3.0820137925, 1.8756303325866757`}, 
     PlotRange -> {{3.0930036, 3.79635128}, {1.9385399115055169`, 
      5.838933804473677}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {3.0820137925, 1.8756303325866757`}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{3.0930036, 3.79635128}, {1.9385399115055169`, 
      5.838933804473677}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485028759108`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948503094141*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-10-10 UQ35_stress_59cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948503097643*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[{{5.725136065, 3.8912180759949577`}, {5.581348176666666, 
         4.203487913925147}, {5.57423712, 3.854510411226679}, {
         5.518743883333333, 4.194451300931378}, {5.506424715, 
         4.06210542107945}, {5.49751791, 3.987482920438007}, {
         5.436610549999999, 4.252017602675652}, {5.4362409, 
         4.656199112100095}, {5.42640628, 4.586107135137818}, {5.36065438, 
         4.492785055393301}, {5.36033267, 1.631199404215613}}]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQrVIZbBa4RdRhqdKcpzYOQg6nZCd68WwVdShcWvH3
2BMhh4UGz7ZNA8pLcf649eCToMOJw9k6s4H8+g+2PyUshRy8glR5fheIOsw6
+rQ7RfKXfUPspyf2haIOuvEdb7edEHRw3Np+Lw7Ivzx7bkycmpBD6s099hL7
RR20p8RMWPtLwEEr/dp7USD/nKeciIGpoEPn+ZogMSDfuYJx5p/LAg5pe94L
rN0n6jC7dZpu7DQhB4WnbzW3AvndP32nmq4RchBtuDRpP5BfJCj1VnWukMPq
mBV/sv+KOjgqFiWdncjvcH3hnXV1QP7swt7ak9ICDjqc5tu0hMUcRDo2Rgre
FnDwvy/JpQ3kvztnZ/LnqIDDEvFrnPZAvslLEf23mwUclC7u+mMbLOZgmrjx
QZqcoINA+4+TnkB+/WGGHWcWCzgEKVRyxAP5LHrCaSarBByqa3qYf3qLOVzs
iInayMDvEP6CfZ6Aj5jD5WUGlZWr+BxCPl7qr2MTc3DhvPtYXkPA4Wb35Wsr
gfwjC72md4UJOLRrztxa/kzMIWXufcGjC/kcwgs6c+cA+ctvr3tvMJPfAQC+
7rW5
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {5.354631522656251, 1.406764376830664}, 
     PlotRange -> {{5.36033267, 5.7252061}, {1.459409630167874, 
      4.723415337074912}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {5.354631522656251, 1.406764376830664}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{5.36033267, 5.7252061}, {1.459409630167874, 
      4.723415337074912}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.732948503160739*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.732946384840078*^9, 3.7329485032210846`*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Averaged data overview", "Subsection",
 CellChangeTimes->{{3.7138421833400097`*^9, 3.713842205334895*^9}, {
  3.713842407108616*^9, 3.71384240874142*^9}, {3.7138431721900377`*^9, 
  3.713843176126772*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"\"\<Measurement folder name: \>\"", "~~", 
         RowBox[{"rawDataDirList", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", "Bold", ",", "14"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"QDataSetsAvg", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "//", "TableForm"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<\\n\>\"", "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "QDataTables", "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{3.7138432111634464`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-15 UQ31_stress_14cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"39", "1.4937245`", "293.928391`"},
    {"38", "1.4871345`", "180.0768645`"},
    {"43", "1.46331675`", "116.4498576`"},
    {"44", "1.4488985`", "117.9017702`"},
    {"45", "1.43240975`", "148.3863602`"},
    {"50", "1.408751`", "216.9133297`"},
    {"53", "1.38674375`", "282.8322949`"},
    {"58", "1.352406`", "300.5819181`"},
    {"59", "1.324718125`", "158.6248802`"},
    {"61", "1.311628625`", "350.833622`"},
    {"57", "1.298095`", "112.2889617`"},
    {"64", "1.280660125`", "69.58187893`"},
    {"65", "1.276001125`", "13.57952192`"},
    {"6", "1.275554125`", "18.11170926`"},
    {"7", "1.267679125`", "32.21658691`"},
    {"66", "1.25881725`", "229.8252686`"},
    {"8", "1.2571759793333332`", "87.25532741666666`"},
    {"10", "1.2477265`", "100.5059535`"},
    {"11", "1.245099`", "89.95447146`"},
    {"0", "1.204870625`", "45.8603842`"},
    {"10", "1.19228425`", "24.97258628`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_4mm_18unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"63", "1.96045275`", "6.045876021`"},
    {"69", "1.955058125`", "6.400160052`"},
    {"58", "1.79466675`", "21.52005642`"},
    {"61", "1.765293`", "166.7919863`"},
    {"64", "1.720007`", "160.1942938`"},
    {"68", "1.693850375`", "134.949893`"},
    {"69", "1.66247475`", "18.20400848`"},
    {"69", "1.662068`", "20.06881546`"},
    {"71", "1.65087325`", "18.31416897`"},
    {"70", "1.6453775`", "52.78181817`"},
    {"4", "1.6430535`", "49.56353861`"},
    {"75", "1.6311665`", "16.86993474`"},
    {"74", "1.615018125`", "11.75274205`"},
    {"73", "1.42762625`", "8.142504092`"},
    {"69", "1.3645725`", "8.025519366`"},
    {"70", "1.258452625`", "5.91614315`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_4mm_20unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"58", "1.93299625`", "158.6905461`"},
    {"59", "1.9221045`", "205.8830389`"},
    {"61", "1.901173625`", "220.7277657`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.73294850661714*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_stress_28cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"47", "2.95506006`", "107.906`"},
    {"46", "2.9395482`", "117.637`"},
    {"48", "2.925812815`", "133.1035`"},
    {"49", "2.9168933949999998`", "130.284`"},
    {"50", "2.90354555`", "113.773`"},
    {"54", "2.8920820799999998`", "102.378`"},
    {"52", "2.885364865`", "157.119`"},
    {"53", "2.872526525`", "153.9105`"},
    {"56", "2.8453423449999997`", "57.5935`"},
    {"58", "2.83470371`", "16.289`"},
    {"59", "2.8125699033333333`", "173.90433333333334`"},
    {"61", "2.81152553`", "209.228`"},
    {"60", "2.79507007`", "33.6465`"},
    {"63", "2.75808509`", "81.55499999999999`"},
    {"64", "2.75797898`", "192.846`"},
    {"65", "2.74465566`", "72.00450000000001`"},
    {"66", "2.7386656666666664`", "197.42566666666667`"},
    {"68", "2.7291341350000002`", "242.759`"},
    {"67", "2.714378713333333`", "224.96699999999998`"},
    {"70", "2.6662027000000004`", "109.8155`"},
    {"71", "2.6593753749999998`", "166.805`"},
    {"72", "2.642062165`", "40.32`"},
    {"75", "2.6255134625`", "131.68599999999998`"},
    {"75", "2.62417618`", "153.116`"},
    {"73", "2.62362229`", "131.04799999999997`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_stress_30cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"41", "3.19167528`", "46.963`"},
    {"48", "3.132492495`", "88.0455`"},
    {"49", "3.12567718`", "82.641`"},
    {"50", "3.119064065`", "156.2905`"},
    {"54", "3.097748795`", "149.2`"},
    {"53", "3.082823725`", "104.5655`"},
    {"58", "3.06211712`", "56.309`"},
    {"59", "3.02271351`", "140.037`"},
    {"62", "2.983366365`", "162.38150000000002`"},
    {"64", "2.96847514`", "167.159`"},
    {"65", "2.9588948950000002`", "105.29750000000001`"},
    {"68", "2.9452892950000003`", "127.85849999999999`"},
    {"66", "2.940605605`", "187.83100000000002`"},
    {"67", "2.9246019333333333`", "244.71633333333335`"},
    {"70", "2.8852762800000002`", "143.15699999999998`"},
    {"71", "2.8794194199999996`", "167.227`"},
    {"72", "2.86297147`", "20.593`"},
    {"73", "2.84071572`", "81.78`"},
    {"75", "2.83377278`", "60.776`"},
    {"74", "2.81427628`", "58.893`"},
    {"76", "2.78798719`", "51.861`"},
    {"4", "2.70206306`", "154.316`"},
    {"5", "2.697743245`", "96.1015`"},
    {"6", "2.6822452500000002`", "143.92899999999997`"},
    {"7", "2.66299099`", "137.0805`"},
    {"8", "2.64802703`", "78.855`"},
    {"9", "2.6443683700000005`", "140.9262`"},
    {"10", "2.62908709`", "35.705`"},
    {"11", "2.623992495`", "89.255`"},
    {"12", "2.61412813`", "26.665`"},
    {"15", "2.57518118`", "10.627`"},
    {"17", "2.56037037`", "6.676`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-05 UQ31_stress_34cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"62", "3.39784094`", "128.161`"},
    {"63", "3.3812811`", "198.286`"},
    {"68", "3.364434684`", "216.56080000000003`"},
    {"69", "3.314629405`", "215.45850000000002`"},
    {"71", "3.30655253`", "117.847`"},
    {"72", "3.2970987666666667`", "192.77666666666664`"},
    {"70", "3.2946932333333327`", "161.17`"},
    {"75", "3.282605055`", "137.4735`"},
    {"73", "3.2645885933333334`", "171.45066666666665`"},
    {"74", "3.2568892853846156`", "319.6094615384615`"},
    {"76", "3.228665935`", "249.8905`"},
    {"1", "3.076583295`", "124.92349999999999`"},
    {"3", "3.058498505`", "110.4695`"},
    {"4", "3.05015508`", "19.388`"},
    {"5", "3.046019179999999`", "123.99000000000001`"},
    {"6", "3.033215615`", "151.678`"},
    {"7", "3.0037578849999997`", "66.517`"},
    {"9", "3.0009795`", "113.862`"},
    {"8", "2.982107055`", "86.3205`"},
    {"11", "2.95435618`", "72.722`"},
    {"13", "2.9478142849999998`", "56.31999999999999`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-08 UQ31_stress_36cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"41", "3.79635128`", "15.127`"},
    {"42", "3.79228005`", "12.67`"},
    {"45", "3.76983164`", "50.014`"},
    {"47", "3.76464634`", "36.299`"},
    {"54", "3.7025227249999997`", "114.17349999999999`"},
    {"61", "3.6259140199999997`", "65.49549999999999`"},
    {"59", "3.6156612074999996`", "193.08125`"},
    {"60", "3.6022071999999996`", "132.2843333333333`"},
    {"68", "3.54816817`", "8.532`"},
    {"66", "3.51609093`", "108.61366666666666`"},
    {"67", "3.5050988`", "20.375`"},
    {"72", "3.46792936`", "84.407`"},
    {"70", "3.465488885`", "192.796`"},
    {"75", "3.4617742466666668`", "183.41933333333333`"},
    {"73", "3.4318809`", "86.962`"},
    {"76", "3.40305739`", "179.72899999999998`"},
    {"1", "3.23110771`", "102.71549999999999`"},
    {"3", "3.2050262800000002`", "116.10050000000001`"},
    {"5", "3.19423747`", "97.07650000000001`"},
    {"4", "3.19310232`", "109.304`"},
    {"6", "3.17995673`", "41.625`"},
    {"11", "3.0930036`", "23.769`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506632764*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-10-10 UQ35_stress_59cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506648389*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"21", "5.725136065`", "48.9705`"},
    {"33", "5.581348176666666`", "66.91933333333333`"},
    {"32", "5.57423712`", "47.2055`"},
    {"34", "5.518743883333333`", "66.31733333333332`"},
    {"31", "5.506424715`", "58.0965`"},
    {"38", "5.49751791`", "53.919`"},
    {"44", "5.436610549999999`", "70.247`"},
    {"42", "5.4362409`", "105.23533333333332`"},
    {"50", "5.42640628`", "98.11175`"},
    {"45", "5.36065438`", "89.37`"},
    {"48", "5.36033267`", "5.11`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506648389*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7329464138137536`*^9, 3.732948506648389*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1218, 657},
WindowMargins->{{10, Automatic}, {Automatic, 7}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 95, 1, 70, "Section"],
Cell[678, 25, 165, 3, 30, "Input"],
Cell[846, 30, 378, 7, 30, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1261, 42, 98, 1, 56, "Section"],
Cell[1362, 45, 562, 15, 30, "Input"],
Cell[1927, 62, 3695, 90, 232, "Input"],
Cell[5625, 154, 2371, 62, 107, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[8033, 221, 104, 1, 56, "Section"],
Cell[CellGroupData[{
Cell[8162, 226, 150, 2, 49, "Subsection"],
Cell[8315, 230, 563, 15, 30, "Input"],
Cell[8881, 247, 2284, 50, 316, "Input"],
Cell[11168, 299, 1051, 23, 50, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[12256, 327, 206, 3, 41, "Subsection"],
Cell[CellGroupData[{
Cell[12487, 334, 984, 25, 126, "Input"],
Cell[CellGroupData[{
Cell[13496, 363, 411, 8, 25, "Print"],
Cell[13910, 373, 1825, 43, 380, "Print"],
Cell[15738, 418, 285, 4, 41, "Print"],
Cell[16026, 424, 408, 8, 25, "Print"],
Cell[16437, 434, 1656, 39, 320, "Print"],
Cell[18096, 475, 285, 4, 41, "Print"],
Cell[18384, 481, 408, 8, 25, "Print"],
Cell[18795, 491, 1718, 42, 365, "Print"],
Cell[20516, 535, 283, 4, 41, "Print"],
Cell[20802, 541, 409, 8, 25, "Print"],
Cell[21214, 551, 4139, 84, 972, "Print"],
Cell[25356, 637, 283, 4, 41, "Print"],
Cell[25642, 643, 411, 8, 25, "Print"],
Cell[26056, 653, 4644, 94, 1123, "Print"],
Cell[30703, 749, 285, 4, 41, "Print"],
Cell[30991, 755, 411, 8, 25, "Print"],
Cell[31405, 765, 4467, 89, 1010, "Print"],
Cell[35875, 856, 283, 4, 41, "Print"],
Cell[36161, 862, 409, 8, 25, "Print"],
Cell[36573, 872, 4066, 81, 929, "Print"],
Cell[40642, 955, 283, 4, 41, "Print"],
Cell[40928, 961, 411, 8, 25, "Print"],
Cell[41342, 971, 2676, 56, 537, "Print"],
Cell[44021, 1029, 285, 4, 41, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44367, 1040, 163, 2, 41, "Subsection"],
Cell[44533, 1044, 23336, 597, 69, "Input"],
Cell[67872, 1643, 968, 19, 30, "Input"],
Cell[68843, 1664, 988, 23, 50, "Input"],
Cell[69834, 1689, 1154, 36, 50, "Input"],
Cell[CellGroupData[{
Cell[71013, 1729, 1066, 27, 55, "Input"],
Cell[72082, 1758, 42234, 861, 272, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114353, 2624, 1258, 33, 69, "Input",
 CellID->11232736],
Cell[115614, 2659, 415, 8, 21, "Message"],
Cell[116032, 2669, 417, 8, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116486, 2682, 1895, 45, 77, "Input"],
Cell[118384, 2729, 9507, 192, 309, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127940, 2927, 232, 7, 49, "Subsection"],
Cell[CellGroupData[{
Cell[128197, 2938, 2487, 56, 220, "Input"],
Cell[CellGroupData[{
Cell[130709, 2998, 421, 8, 25, "Print"],
Cell[131133, 3008, 13779, 283, 261, "Print"],
Cell[144915, 3293, 295, 4, 41, "Print"],
Cell[145213, 3299, 419, 8, 25, "Print"],
Cell[145635, 3309, 13965, 282, 265, "Print"],
Cell[159603, 3593, 298, 4, 41, "Print"],
Cell[159904, 3599, 421, 8, 25, "Print"],
Cell[160328, 3609, 12947, 266, 265, "Print"],
Cell[173278, 3877, 298, 4, 41, "Print"],
Cell[173579, 3883, 424, 8, 25, "Print"],
Cell[174006, 3893, 14543, 295, 265, "Print"],
Cell[188552, 4190, 295, 4, 41, "Print"],
Cell[188850, 4196, 424, 8, 25, "Print"],
Cell[189277, 4206, 14755, 301, 264, "Print"],
Cell[204035, 4509, 296, 4, 41, "Print"],
Cell[204334, 4515, 422, 8, 25, "Print"],
Cell[204759, 4525, 14440, 294, 265, "Print"],
Cell[219202, 4821, 296, 4, 41, "Print"],
Cell[219501, 4827, 422, 8, 25, "Print"],
Cell[219926, 4837, 14222, 290, 265, "Print"],
Cell[234151, 5129, 296, 4, 41, "Print"],
Cell[234450, 5135, 422, 8, 25, "Print"],
Cell[234875, 5145, 13772, 281, 265, "Print"],
Cell[248650, 5428, 298, 4, 41, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[249009, 5439, 211, 3, 41, "Subsection"],
Cell[CellGroupData[{
Cell[249245, 5446, 859, 23, 126, "Input"],
Cell[CellGroupData[{
Cell[250129, 5473, 376, 7, 25, "Print"],
Cell[250508, 5482, 1619, 38, 320, "Print"],
Cell[252130, 5522, 250, 3, 41, "Print"],
Cell[252383, 5527, 373, 7, 25, "Print"],
Cell[252759, 5536, 1393, 33, 245, "Print"],
Cell[254155, 5571, 250, 3, 41, "Print"],
Cell[254408, 5576, 373, 7, 25, "Print"],
Cell[254784, 5585, 843, 20, 50, "Print"],
Cell[255630, 5607, 251, 3, 41, "Print"],
Cell[255884, 5612, 377, 7, 25, "Print"],
Cell[256264, 5621, 1841, 42, 380, "Print"],
Cell[258108, 5665, 251, 3, 41, "Print"],
Cell[258362, 5670, 377, 7, 25, "Print"],
Cell[258742, 5679, 2084, 49, 485, "Print"],
Cell[260829, 5730, 251, 3, 41, "Print"],
Cell[261083, 5735, 377, 7, 25, "Print"],
Cell[261463, 5744, 1672, 38, 320, "Print"],
Cell[263138, 5784, 251, 3, 41, "Print"],
Cell[263392, 5789, 377, 7, 25, "Print"],
Cell[263772, 5798, 1700, 39, 335, "Print"],
Cell[265475, 5839, 251, 3, 41, "Print"],
Cell[265729, 5844, 377, 7, 25, "Print"],
Cell[266109, 5853, 1191, 28, 170, "Print"],
Cell[267303, 5883, 251, 3, 41, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

